% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hex.R
\name{plot_hex}
\alias{plot_hex}
\title{Group and/or log-scale hexagonal binning}
\usage{
plot_hex(
  x,
  y,
  id = NA,
  select = NA,
  uniform = TRUE,
  bins = 60,
  xbnds = range(x, na.rm = TRUE),
  ybnds = range(y, na.rm = TRUE),
  xlim = xbnds,
  ylim = ybnds,
  log = "",
  shape = 1,
  mincnt = 1,
  maxcnt = NA,
  colorcut = seq(0, 1, length = 17),
  colramp = function(n) matlab.like(length(colorcut) - 1),
  trans = NULL,
  inv = NULL,
  border = NULL,
  lwd = 0.1,
  cex = 1,
  main = "",
  xlab = "x",
  ylab = "y",
  xaxis = TRUE,
  yaxis = TRUE,
  xaxs = "r",
  yaxs = "r",
  box = TRUE,
  mar = c(0.15, 0.125, 0.15, 0.2),
  legend = TRUE,
  leg_sep = 0.1,
  xpd_hex = 0.75,
  xpd_leg = 1.5,
  l = list(x = NULL, y = NULL, default.units = "native"),
  g = list(x = NULL, y = NULL, default.units = "native"),
  t = list(label = NULL, default.units = "native"),
  plot = TRUE
)
}
\arguments{
\item{x, y}{vectors giving the coordinates of the bivariate data points to be
binned.}

\item{id}{a vector of ids for each x value, to separate different groups of
data}

\item{select}{the groups of ids to plot}

\item{uniform}{whether to keep the creaks defined by the entire matrixes when
selecting only a part of it}

\item{bins}{the number of bins partitioning the range of xbnds.}

\item{xbnds, ybnds}{horizontal and vertical limits of the binning region in
x or y units respectively; must be numeric vector of length 2.}

\item{xlim, ylim}{the limits of the plot}

\item{log}{a character string which contains "x" if the x axis is to be
logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if both
axes are to be logarithmic.}

\item{shape}{the theoretical shape = yheight/xwidth of the plotting. This
adapts the form of the hexagons accordingly.}

\item{mincnt, maxcnt}{fraction of cell area for the lowest and largest count,
respectively}

\item{colorcut}{vector of values covering [0, 1] that determine hexagon color
class boundaries and hexagon legend size boundaries. Alternatively, an
integer (<= maxcnt) specifying the number of equispaced colorcut values in
[0,1].}

\item{colramp}{function accepting an integer n as an argument and returning n
colors.}

\item{trans}{a transformation function for the counts such as
\code{\link{log10}}}

\item{inv}{the inverse transformation function (if
\code{trans = \link{log10}}, \code{inv} should for instance be
\code{function(x) 10^x}.}

\item{border}{the color of the border of the hexagons. By default it will be
the color of the filling}

\item{lwd}{the width of the border of the hexagons.}

\item{cex}{the magnification of text.}

\item{main}{main title.}

\item{xlab, ylab}{x and y axis labels respectively.}

\item{xaxis, yaxis}{whether to plot the x and y axes respectively.}

\item{xaxs, yaxs}{The style of axis interval calculation to be used for the
axes. By default the style "r" (regular) first extends the data range by 4
percent at each end and then finds an axis with pretty labels that fits
within the extended range. Style "i" (internal) just finds an axis with
pretty labels that fits within the original data range.}

\item{box}{whether to plot a box.}

\item{mar}{a numerical vector of the form c(bottom, left, top, right) which
gives the room the give to the margins in Normalised Parent Coordinates
(see \code{grid} package for more information)}

\item{legend}{whether to plot the legend.}

\item{leg_sep}{the distance between hexagons and text f the legend in
Normalised Parent Coordinates left on the right margin}

\item{xpd_hex}{factor to expand the legend hexagons}

\item{xpd_leg}{factor to expand the height of the legend}

\item{l}{a list of arguments to feed to \code{grid::grid.polyline}
ATTENTION the grid package has to be loaded}

\item{g}{a list of arguments to feed to \code{grid::grid.polygon}
ATTENTION the grid package has to be loaded}

\item{t}{a list of arguments to feed to \code{grid::grid.text}
ATTENTION the grid package has to be loaded}

\item{plot}{whether to plot. If FALSE, returns a grob.}
}
\description{
Group and/or log-scale hexagonal binning. Provides a legend
indicating the count representations. USES THE GRID GRAPHICAL SYSTEM, BASE
GRAPHICS NOT SUPPORTED. To add lines, polygons or text, use the l, g and t
arguments.
}
\examples{
library(grid) # To use the gpar function

set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
        rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7, sifting = 10,
                repl = 10, comb = 10, factor_noise = 10,
                 speak = FALSE)

\dontrun{
plot_emd(dec, dir = tempdir())}

integrity(xy, dec)
parsimony(dec)

ht  <- inst.pulse(dec, plot = FALSE)

plot_hex(x = 1/ht$f, y = ht$a, bins = 100, ybnds = c(0,2),
         log = "x", trans = log10, inv = function(x) 10^x,
         main = "Spectral Population", xlab = "Period", ylab = "Amplitude")

plot_hex(x = 1/ht$f, y = ht$a, bins = 100, ybnds = c(0,2),
         log = "x", trans = log10, inv = function(x) 10^x,
         main = "Spectral Population", xlab = "Period", ylab = "Amplitude",
         id = ht$mode, select = c(4,6,7),
         l = list(x = c(30, 30, 240, 240), y = unit(c(0,1,0,1), "npc"),
                 id = c(1,1,2,2), gp = gpar(col = c("red", "blue"), lwd = 2)),
        g = list(x = c(18, 50, 50, 18, 18, 50, 50, 18),
                 y = c(0, 0, 1.9, 1.9, 2.05, 2.05, 1.95, 1.95),
                 id = c(1,1,1,1,2,2,2,2),
                 gp = gpar(col = c("red", NA), fill = c(NA, "white"), lwd = 2)),
        t = list(label = "Mode 4", x = 30, y = 2, gp = gpar(col = "red")))

}
