% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremist.R
\name{extremist}
\alias{extremist}
\title{Gives local extrema and zero crossings intervals}
\usage{
extremist(xy, bound = FALSE, local = TRUE, zc = TRUE)
}
\arguments{
\item{xy}{the values where to find the local extremas}

\item{bound}{whether to consider the first and last points as both
minima and maxima, for special purposes. Default is F, has it should be.}

\item{local}{whether to consider the first and last points as local
minima and maxima, if TRUE by default, otherwise these first and last points
will be ignored}

\item{zc}{whether to return the zero crossings}
}
\value{
a list of the indexes of the left (l) and right (r) boundaries for
the minima (minindex), maxima (maxindex) and zero crossing (cross), along
with the number of extrema and zero crossings
}
\description{
Gives local minimas, maximas and zero crossings. Optimised for
large data sets; the sky is the limit (and by the sky I mean the ability of
R and your computer to memorise large data sets; but within this limit the
algorithm can handle millions of points quickly).
}
\examples{
# Function script ----

xy <- c(1,0,0,0,4,5,5,0.5,-0.5,0.5,0,2,2,1,-1,-1,1,1,0,0,-4,-2,2,1,0,0.5,0,
        NA, 0.5,0,-0.5,3,2,3,0,0.5,4,4,0)

impressme <- 0 # Increase up to 5 or 6 to be impressed (bugs if your system
               # can't handle the size of the data).
               # If you increase it, do not run the plot script.

xy <- rep(xy, round(10^impressme))

print(paste("You are running ", length(xy), " points", sep = ""))

res <- extremist(xy)



# Plot script: do not run if you increase the impressme parameter ----

mini <- unique(c(res$minindex[[1]], res$minindex[[2]]))
maxi <- unique(c(res$maxindex[[1]], res$maxindex[[2]]))
zeri <- unique(c(res$cross[[1]], res$cross[[2]]))

l <- length(xy)

opar <- par("mfrow")

par(mfrow = c(3,1))

plot(1:l, xy, type = "o",pch = 19)
points(mini, xy[mini], pch = 19, col = "blue")

plot(1:l, xy, type = "o",pch = 19)
points(maxi, xy[maxi], pch = 19, col = "red")

plot(1:l, xy, type = "o",pch = 19)
points(zeri, xy[zeri], pch = 19, col = "green")
abline(h = 0, col = "grey")

par(mfrow = opar)

}
