% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.survival.R
\name{dose.survival}
\alias{dose.survival}
\title{Extract interval-censored dose tolerance data from a dose titration study}
\usage{
dose.survival(de)
}
\arguments{
\item{de}{A data frame describing a dose-titration study}
}
\value{
A \code{Surv} object of type='interval2'
}
\description{
Constructs a \code{\link[survival]{Surv}} object from a dose-escalation
experiment, using interval-censoring constructs of \code{type='interval2'}.
}
\examples{
CV <- 0.7; mean_mtd <- 1.0
shape <- CV^-2; scale <- mean_mtd/shape
trial <- new("DE", doses=0.25 * 1.4^(0:6),
             MTDi=rgamma(24, shape=shape, scale=scale),
             units="mg")
trial <- titration(trial, periods=10)
dose.survival(trial@data)

}
\seealso{
\code{\link{dose.survfit}}
}
\author{
David C. Norris
}
\keyword{survival}
