% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testParse.R
\name{testParse}
\alias{testParse}
\title{Parse an expression according to DataSHIELD syntax rules and returns an Abstract Syntaxic Tree (AST) node.}
\usage{
testParse(expr, debug = FALSE)
}
\arguments{
\item{expr}{Expression}

\item{debug}{Parser debug logger activated}
}
\value{
An Abstract Syntaxic Tree node
}
\description{
Parse an expression according to DataSHIELD syntax rules and returns an Abstract Syntaxic Tree (AST) node.
}
\examples{
\dontrun{
# a function call with a valid formula
ast <- testParse("someregression(D$height ~ D$diameter + D$length)")
# a function call with an invalid formula including a function call
testParse("someregression(D$height ~ D$diameter + poly(D$length,3,raw=TRUE))")
}
}
