#' DataSHIELD login data for the TESTING.DATASET simulated datasets
#'
#' DataSHIELD login data.frame for connecting with TESTING.DATASET datasets which purpose is to
#' evaluate each base data types.
#'
#' | **Field**          | **Description**                  | **Type** | **Note** |
#' | ------------------ | -------------------------------- | -------- | -------- |
#' | server             | Server/study name                | char     ||
#' | url                | Server/study URL                 | char     | DSLiteServer instance symbol name |
#' | user               | User name                        | char     | Always empty for DSLiteServer |
#' | password           | User password                    | char     | Always empty for DSLiteServer |
#' | table              | Table unique name                | char     | As registered in the DSLiteServer |
#' | options            | Connection options               | char     | Always empty for DSLiteServer |
#' | driver             | Connection driver                | char     | DSLiteServer |
#'
#' @name logindata.dslite.testing.dataset
#' @docType data
#' @keywords data
NULL

#' Simulated dataset TESTING.DATASET 1
#'
#' Simulated dataset TESTING.DATASET 1, in a data.frame with 71 observations of 17 harmonized variables.
#'
#' | **Variable**         | **Description**                  | **Type** |
#' | -------------------- | -------------------------------- | -------- |
#' | ID                   | Dummy data                       | integer  |
#' | CHARACTER            | Dummy data                       | char     |
#' | LOGICAL              | Dummy data                       | logical  |
#' | NA_VALUES            | Dummy data                       | logical  |
#' | NULL_VALUES          | Dummy data                       | logical  |
#' | INTEGER              | Dummy data                       | integer  |
#' | NON_NEGATIVE_INTEGER | Dummy data                       | integer  |
#' | POSITIVE_INTEGER     | Dummy data                       | integer  |
#' | NEGATIVE_INTEGER     | Dummy data                       | integer  |
#' | NUMERIC              | Dummy data                       | numeric  |
#' | NON_NEGATIVE_NUMERIC | Dummy data                       | numeric  |
#' | POSITIVE_NUMERIC     | Dummy data                       | numeric  |
#' | NEGATIVE_NUMERIC     | Dummy data                       | numeric  |
#' | FACTOR_CHARACTER     | Dummy data                       | factor   |
#' | FACTOR_INTEGER       | Dummy data                       | factor   |
#' | IDENTIFIER           | Dummy data                       | integer  |
#' | CATEGORY             | Dummy data                       | integer  |
#'
#' @name TESTING.DATASET1
#' @docType data
#' @keywords data
NULL

#' Simulated dataset TESTING.DATASET 2
#'
#' Simulated dataset TESTING.DATASET 2, in a data.frame with 71 observations of 17 harmonized variables.
#'
#' | **Variable**         | **Description**                  | **Type** |
#' | -------------------- | -------------------------------- | -------- |
#' | ID                   | Dummy data                       | integer  |
#' | CHARACTER            | Dummy data                       | char     |
#' | LOGICAL              | Dummy data                       | logical  |
#' | NA_VALUES            | Dummy data                       | logical  |
#' | NULL_VALUES          | Dummy data                       | logical  |
#' | INTEGER              | Dummy data                       | integer  |
#' | NON_NEGATIVE_INTEGER | Dummy data                       | integer  |
#' | POSITIVE_INTEGER     | Dummy data                       | integer  |
#' | NEGATIVE_INTEGER     | Dummy data                       | integer  |
#' | NUMERIC              | Dummy data                       | numeric  |
#' | NON_NEGATIVE_NUMERIC | Dummy data                       | numeric  |
#' | POSITIVE_NUMERIC     | Dummy data                       | numeric  |
#' | NEGATIVE_NUMERIC     | Dummy data                       | numeric  |
#' | FACTOR_CHARACTER     | Dummy data                       | factor   |
#' | FACTOR_INTEGER       | Dummy data                       | factor   |
#' | IDENTIFIER           | Dummy data                       | integer  |
#' | CATEGORY             | Dummy data                       | integer  |
#'
#' @name TESTING.DATASET2
#' @docType data
#' @keywords data
NULL

#' Simulated dataset TESTING.DATASET 3
#'
#' Simulated dataset TESTING.DATASET 3, in a data.frame with 71 observations of 17 harmonized variables.
#'
#' | **Variable**         | **Description**                  | **Type** |
#' | -------------------- | -------------------------------- | -------- |
#' | ID                   | Dummy data                       | integer  |
#' | CHARACTER            | Dummy data                       | char     |
#' | LOGICAL              | Dummy data                       | logical  |
#' | NA_VALUES            | Dummy data                       | logical  |
#' | NULL_VALUES          | Dummy data                       | logical  |
#' | INTEGER              | Dummy data                       | integer  |
#' | NON_NEGATIVE_INTEGER | Dummy data                       | integer  |
#' | POSITIVE_INTEGER     | Dummy data                       | integer  |
#' | NEGATIVE_INTEGER     | Dummy data                       | integer  |
#' | NUMERIC              | Dummy data                       | numeric  |
#' | NON_NEGATIVE_NUMERIC | Dummy data                       | numeric  |
#' | POSITIVE_NUMERIC     | Dummy data                       | numeric  |
#' | NEGATIVE_NUMERIC     | Dummy data                       | numeric  |
#' | FACTOR_CHARACTER     | Dummy data                       | factor   |
#' | FACTOR_INTEGER       | Dummy data                       | factor   |
#' | IDENTIFIER           | Dummy data                       | integer  |
#' | CATEGORY             | Dummy data                       | integer  |
#'
#' @name TESTING.DATASET3
#' @docType data
#' @keywords data
NULL
