% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FimIMI.R
\name{FimIMI}
\alias{FimIMI}
\title{FimIMI: Multiple Runs of Improved Multiple Imputation (IMI)}
\usage{
FimIMI(d, R, n, M, batch = 0)
}
\arguments{
\item{d}{The data structure.}

\item{R}{Number of runs to perform.}

\item{n}{Vector of sample sizes for each group.}

\item{M}{Number of multiple imputations per run.}

\item{batch}{Batch number (default is 0). This can be used to distinguish different batches of runs.}
}
\value{
A list containing:
\item{R}{Vector of run numbers.}
\item{Beta}{Matrix of regression coefficients for each run.}
\item{comm}{Vector of indicator variables for each run.}
}
\description{
This function performs multiple runs of the Improved Multiple Imputation (IMI) estimation
and collects the results. It is designed to facilitate batch processing and repeated runs of IMI.
}
\details{
This function assumes that the data structure \code{d} is properly defined and contains the necessary information.
The function repeatedly calls the \code{IMI} function and collects the regression coefficients and indicator variables.
}
\examples{
# Example data
set.seed(123)
n <- c(300, 300, 400)  # Sample sizes for each group
p <- 5  # Number of independent variables
d <- list(p = p, Y = rnorm(sum(n)), X0 = matrix(rnorm(sum(n) * p), ncol = p))

# Call FimIMI function
result <- FimIMI(d = d, R = 10, n = n, M = 20, batch = 1)

# View results
print(result$Beta)  # Regression coefficients for each run

}
