% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DImulti_classMethods.R
\name{print.DImulti}
\alias{print.DImulti}
\title{print.DImulti}
\usage{
\method{print}{DImulti}(x, ...)
}
\arguments{
\item{x}{an object of class DImulti}

\item{...}{some methods for this generic function require additional arguments. None are used in
this method.}
}
\value{
object x
}
\description{
Print details of the fitted DI models supplied
}
\details{
The appearance of the printed information will differ depending on whether a user has installed
some combination of the suggested packages "crayon", "cli", and "fansi".
These changes are mainly cosmetic, with crayon making the output easier to read, cli providing
links to help files, and fansi enabling the reading of special characters in R markdown (Rmd)
files. See 'Examples' below for suggested code to include in Rmd files.
}
\examples{
## Set up for R markdown for crayon and cli output if user has packages installed

if(requireNamespace("fansi", quietly = TRUE) &
   requireNamespace("crayon", quietly = TRUE) &
   requireNamespace("cli", quietly = TRUE))
{
 options(crayon.enabled = TRUE)

 ansi_aware_handler <- function(x, options)
 {
  paste0(
    "<pre class=\"r-output\"><code>",
    fansi::sgr_to_html(x = x, warn = FALSE, term.cap = "256"),
    "</code></pre>"
  )
 }

 old_hooks <- fansi::set_knit_hooks(knitr::knit_hooks,
                                    which = c("output", "message", "error", "warning"))

 knitr::knit_hooks$set(
   output = ansi_aware_handler,
   message = ansi_aware_handler,
   warning = ansi_aware_handler,
   error = ansi_aware_handler
  )
 }
#################################################################################################

## Usage

model <- DImulti(prop = c("G1", "G2", "L1", "L2"), y = "Y", eco_func = c("Var", "un"),
                 unit_IDs = "Plot", theta = c(0.5, 1, 1.2), DImodel = "FG",
                 FG = c("Grass", "Grass", "Legume", "Legume"), extra_fixed = ~ Density,
                 method = "REML", data = dataBEL)

print(model)

}
\seealso{
\code{\link[base]{print}} which this function wraps.
}
