% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_config.R
\name{get_config}
\alias{get_config}
\title{Reads a config yaml file and return the value for a given key.}
\usage{
get_config(config_file, config_key)
}
\arguments{
\item{config_file}{A character string. The path to the config.yml-file
containing the database configuration.}

\item{config_key}{A character string. The name of the corresponding
database. This string must be conform with the corresponding config
section in the config.yml-file.}
}
\value{
If successful it returns the value, Null otherwise.
}
\description{
Reads a config yaml file and return the value for a given key.
}
\examples{
\donttest{
utils_path <- tempdir()
config <- get_config(
  config_file = paste0(utils_path, "/MISC/email.yml"),
  config_key = "email"
)}

}
