% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initTask.R
\name{initTask}
\alias{initTask}
\title{Initialize a task}
\usage{
initTask(
  project,
  package,
  taskname,
  sponsor = getTaskSponsor(),
  author = getTaskAuthor(),
  dirCreate = TRUE,
  templateCreate = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{project}{Project name.}

\item{package}{Package name.}

\item{taskname}{Task name.}

\item{sponsor}{Sponsor name, default set by \code{\link{setTaskSponsor}}.}

\item{author}{Author name, system username by default.}

\item{dirCreate}{logical, if TRUE (by default) the directory structure for the task is created in the repository.}

\item{templateCreate}{create the prefilled Rmd template for the task, default value: FALSE.}

\item{overwrite}{logical, if TRUE and the task already exists, overwrite its parameters.}
}
\value{
\code{\link{D4TAlinkTask}} object
}
\description{
During the initialization:
\itemize{
\item The folder structure for the task is created
in the data repository.
\item The task properties are also
saved in rds and json format.
}
Please note that it is recommended
to load packages for your analysis
before initializing the task.
}
