% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_forest}
\alias{plot_forest}
\title{plot_forest}
\usage{
plot_forest(
  model,
  title = "Hazard Ratio",
  cpositions = c(0.02, 0.22, 0.4),
  fontsize = 0.7,
  refLabel = "reference",
  noDigits = 2
)
}
\arguments{
\item{model}{Coxmos model.}

\item{title}{Character. Forest plot title (default: "Hazard Ratio").}

\item{cpositions}{Numeric vector. Relative positions of first three columns in the OX scale
(default: c(0.02, 0.22, 0.4)).}

\item{fontsize}{Numeric. Elative size of annotations in the plot (default: 0.7).}

\item{refLabel}{Character. Label for reference levels of factor variables (default: "reference").}

\item{noDigits}{Numeric. Number of digits for estimates and p-values in the plot (default: 2).}
}
\value{
A ggplot object representing the forest plot. The plot visualizes the hazard ratios and
their confidence intervals for each variable or component from the Coxmos model.
}
\description{
Generates a forest plot for Coxmos models, visualizing the hazard ratios and their confidence
intervals. The function leverages the capabilities of the \code{survminer::ggforest} function to
produce a comprehensive representation of the model's coefficients.
}
\details{
The forest plot is a graphical representation of the point estimates and confidence intervals of
the hazard ratios derived from a Coxmos model. Each row in the plot corresponds to a variable or
component from the model, with a point representing the hazard ratio and horizontal lines
indicating the confidence intervals. The plot provides a visual assessment of the significance and
magnitude of each variable's effect on the outcome.

The function starts by validating the provided model to ensure it belongs to the Coxmos class and
is among the recognized Coxmos models. If the model is valid, the function then proceeds to
generate the forest plot using the \code{survminer::ggforest} function. Several customization options
are available, including adjusting the title, column positions, font size, reference label, and
the number of digits displayed for estimates and p-values.

Forest plots are instrumental in the field of survival analysis, offering a concise visualization
of the model's results, making them easier to interpret and communicate.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
splsicox.model <- splsicox(X, Y, n.comp = 2, penalty = 0.5, x.center = TRUE, x.scale = TRUE)
plot_forest(splsicox.model)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
