% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_psychrometric.R
\name{graph_psychrometric}
\alias{graph_psychrometric}
\title{Create a Psychrometric Chart}
\usage{
graph_psychrometric(
  mydata,
  Temp = "Temp",
  RH = "RH",
  data_col = NULL,
  data_alpha = 0.5,
  LowT = 16,
  HighT = 25,
  LowRH = 40,
  HighRH = 60,
  Temp_range = c(0, 40),
  y_func = "calcMR",
  ...
)
}
\arguments{
\item{mydata}{A data frame containing temperature and relative humidity data.}

\item{Temp}{Column name in mydata for temperature values.}

\item{RH}{Column name in mydata for relative humidity values.}

\item{data_col}{Name of column to use for colouring points. Default is "Sensor" if present, otherwise "RH".}

\item{data_alpha}{Value to supply for make points more or less transparent. Default is 0.5.}

\item{LowT}{Numeric value for lower temperature limit of the target range. Default is 16°C.}

\item{HighT}{Numeric value for upper temperature limit of the target range. Default is 25°C.}

\item{LowRH}{Numeric value for lower relative humidity limit of the target range. Default is 40\%.}

\item{HighRH}{Numeric value for upper relative humidity limit of the target range. Default is 60\%.}

\item{Temp_range}{Numeric vector of length 2 specifying the overall temperature range for the chart. Default is c(0, 40).}

\item{y_func}{Function to calculate y-axis values. See above for options, default is mixing ratio (`calcMR`).}

\item{...}{Additional arguments passed to y_func.}
}
\value{
A ggplot object representing the psychrometric chart.
}
\description{
This function generates a psychrometric chart based on input temperature and relative humidity data.
}
\details{
Humidity and conservation functions can be used for the y-axis.

\itemize{
   \item calcHR: Humidity Ratio (g/kg)
   \item calcMR: Mixing Ratio (g/kg)
   \item calcAH: Absolute Humidity (g/m^3)
   \item calcSH: Specific Humidity (g/kg)
   \item calcAD: Air Density (kg/m^3)
   \item calcDP: Dew Point (°C)
   \item calcFP: Frost Point (°C)
   \item calcEnthalpy: Enthalpy (kJ/kg)
   \item calcPws: Saturation vapor pressure (hPa)
   \item calcPw: Water Vapour Pressure (hPa)
   \item calcPI: Preservation Index
   \item calcLM: Lifetime
   \item calcEMC_wood: Equilibrium Moisture Content (wood)
}
}
\examples{

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 100)

# Basic usage with default settings
graph_psychrometric(mydata, Temp, RH)

# Custom temperature and humidity ranges
graph_psychrometric(mydata, Temp, RH, LowT = 8, HighT = 28, LowRH = 30, HighRH = 70)

# Using a different psychrometric function (e.g., Absolute Humidity)
graph_psychrometric(mydata, Temp, RH, y_func = calcAH)

# Adjusting the overall temperature range of the chart
graph_psychrometric(mydata, Temp, RH, Temp_range = c(12, 30))



}
