% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fg_flux.R
\name{fg_flux}
\alias{fg_flux}
\alias{fg_flux.cfp_dat}
\alias{fg_flux.cfp_fgres}
\alias{fg_flux.cfp_fgmod}
\title{Flux-gradient method}
\usage{
fg_flux(x, ...)

\method{fg_flux}{cfp_dat}(x, ...)

\method{fg_flux}{cfp_fgres}(x, ...)

\method{fg_flux}{cfp_fgmod}(x, ...)
}
\arguments{
\item{x}{A \code{cfp_dat} object with all the necessary input datasets.}

\item{...}{
  Arguments passed on to \code{\link[=cfp_fgmod]{cfp_fgmod}}
  \describe{
    \item{\code{gases}}{(character) A character vector defining the gases for which
fluxes shall be calculated.}
    \item{\code{modes}}{(character) A character vector specifying mode(s) for dcdz
calculation. Can be \code{"LL"},\code{"LS"},\code{"EF"}.
\describe{
\item{LL}{local linear approach: within each layer a linear model is
evaluated of concentration over the depth.}
\item{LS}{linear spline approach: A linear spline is fitted over the
complete profile with nodes at the layer intersections.}
\item{EF}{exponential fit approach: An exponential function of form
y=a+b*x^c is fit of concentration against depth. Using the first derivative
of that function the concentration gradient is evaluated for each layer.}
\item{DA}{exponential fit approach: An exponential function of form
\code{y=a+b*(1-exp(-a*x))} is fit of concentration against depth. Using the
first derivative of that function the concentration gradient is evaluated
for each layer. From Davidson (2006).}
}}
    \item{\code{param}}{(character) A vector containing the the parameters of soilphys,
for which means should be calculated, must contain "c_air" and "DS", more
parameters may help interpretation.}
    \item{\code{funs}}{(character) A vector defining the type of mean to be used for
each parameter in \code{param}. One of "arith" or "harm".}
  }}
}
\value{
A \link{cfp_fgres} model result.
}
\description{
\code{fg_flux()} implements different approaches to the flux-gradient
method (FGM). It takes a valid input dataset from \code{cfp_dat()} and
calculates for each layer defined in \code{cfp_layers_map()}.
}
\details{
The model result contains the original data, but adds the
dataset \code{FLUX}, which contains the calculated flux rates.
You can use functions \link{efflux} and \link{production} to calculate
different elements or access the raw result with \code{model_result$FLUX}.
}
\examples{
fg_flux(ConFluxPro::base_dat)

}
\references{
DAVIDSON, E. A., SAVAGE, K. E., TRUMBORE, S. E., & BORKEN, W.
(2006). Vertical partitioning of CO2 production within a temperate forest
soil. In Global Change Biology (Vol. 12, Issue 6, pp. 944–956). Wiley.
https://doi.org/10.1111/j.1365-2486.2005.01142.x
}
\seealso{
Other flux models: 
\code{\link{pro_flux}()}
}
\concept{flux models}
