% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepflux.R
\name{deepflux}
\alias{deepflux}
\title{Extract flux rates from deep soil}
\usage{
deepflux(x, ...)
}
\arguments{
\item{x}{A valid \code{cfp_pfres()} object.}

\item{...}{Further parameters passed on to \code{efflux()} in case of
\code{cfp_fgres}.}
}
\value{
data.frame with F0 (\eqn{µmol / m^2 / s})
}
\description{
Extract the incoming and outgoing flux from below the deepest
layer of a \code{pro_flux()} model. This returns zero, if \code{zero_flux=TRUE}.
}
\details{
F0 represents the flux below the lowest layer defined in the
\code{cfp_pfres()} model
}
\examples{
PROFLUX <- ConFluxPro::base_dat |> pro_flux()

deepflux(PROFLUX)


}
