% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_soilphys.R
\name{complete_soilphys}
\alias{complete_soilphys}
\title{(Re-)calculate soil physical parameters}
\usage{
complete_soilphys(
  soilphys,
  DSD0_formula = NULL,
  gases = NULL,
  overwrite = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{soilphys}{(dataframe) the soilphys dataframe}

\item{DSD0_formula}{(character) A character vector defining the way DSD0
should be calculated. Must refer to existing columns in soilphys. See
examples below.}

\item{gases}{(character) A character vector defining the gases for which to
calculate D0 and DS.}

\item{overwrite}{(logical) If true, already existing columns are overwritten.}

\item{quiet}{(logical) Suppress messages.}
}
\value{
A \code{data.frame()} with all necessary columns for
\link{cfp_soilphys}.
}
\description{
This function completes the soilphys dataset by calculating
different parameters if necessary, as long as all required parameters are
available. Diffusion coefficients, as well as the air density are
calculated if missing.
}
\examples{
soilphys_barebones <- ConFluxPro::soilphys |>
 dplyr::select(
   c("site",
     "Date",
     "upper",
     "lower",
     "depth",
     "t",
     "p",
     "TPS",
     "SWC",
     "a",
     "b")
     )

complete_soilphys(
  soilphys_barebones,
  DSD0_formula = "a*AFPS^b",
  gases = "CO2")


}
\seealso{
D0_massman

Other soilphys: 
\code{\link{check_soilphys}()},
\code{\link{discretize_depth}()},
\code{\link{soilphys_layered}()}
}
\concept{soilphys}
