% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_soilphys.R
\name{check_soilphys}
\alias{check_soilphys}
\title{Check for complete and correct soil physical parameters}
\usage{
check_soilphys(df, extra_vars = c(), id_cols)
}
\arguments{
\item{df}{(dataframe) the soilphys dataframe}

\item{extra_vars}{(character vector) column names of additional variables to
be checked.}

\item{id_cols}{(character vector) the columns that, together, identify a
site uniquely (e.g. site, repetition)}
}
\value{
data frame of 'suspicious' parameter/depth combinations, where all
values are NA.
}
\description{
This function analyses the soilphys dataframe before the flux
calculation. It presents a warning, if there are variables missing and also
looks for suspicious patterns that suggest an error in the interpolation
made by discretize_depth. Mainly checks if certain columns are present
and if they are missing, if they can be calculated from the data present.
Looks for the following columns by default:
"upper","lower","TPS","SWC","AFPS","t","p","DSD0","D0","DS"
}
\examples{
check_soilphys(ConFluxPro::soilphys, id_cols = c("site", "Date"))


}
\seealso{
Other soilphys: 
\code{\link{complete_soilphys}()},
\code{\link{discretize_depth}()},
\code{\link{soilphys_layered}()}
}
\concept{soilphys}
