% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_error.R
\name{bootstrap_error}
\alias{bootstrap_error}
\alias{bootstrap_error.cfp_altres}
\alias{bootstrap_error.cfp_dat}
\alias{bootstrap_error.cfp_fgmod}
\alias{bootstrap_error.cfp_pfmod}
\alias{make_bootstrap_model}
\alias{make_bootstrap_model.cfp_pfmod}
\alias{calculate_bootstrap_error}
\alias{calculate_bootstrap_error.cfp_pfmod}
\title{Estimate model uncertainty}
\usage{
bootstrap_error(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

\method{bootstrap_error}{cfp_altres}(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

\method{bootstrap_error}{cfp_dat}(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

\method{bootstrap_error}{cfp_fgmod}(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

\method{bootstrap_error}{cfp_pfmod}(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

make_bootstrap_model(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

\method{make_bootstrap_model}{cfp_pfmod}(
  x,
  n_samples = 50,
  sd_x_ppm = NULL,
  n_replicates = NULL,
  sample_from = "gasdata",
  rep_cols = NULL
)

calculate_bootstrap_error(x, y)

\method{calculate_bootstrap_error}{cfp_pfmod}(x, y)
}
\arguments{
\item{x}{A \code{cfp_pfres} model result from a call to \code{\link[=pro_flux]{pro_flux()}}.}

\item{n_samples}{The number of samples to take in the bootstrapping.}

\item{sd_x_ppm}{An optional estimate of the standard deviation of x_ppm. Can
be either
\itemize{
\item{a single value applied equally to all}
\item{a data.frame with a column of the same name that
maps a value to every observation depth. See \code{\link[=depth_structure]{depth_structure()}} for an easy
way to create it.}
\item{be provided as its own column already present in \code{x$gasdata}.
}
}}

\item{n_replicates}{The number of replicates to be generated if sd_x_ppm is
set.}

\item{sample_from}{From which dataset to sample the bootstrapping dataset.
Can either be \code{'gasdata'} or \code{'soilphys'} or \code{'both'}.}

\item{rep_cols}{The id_cols that represent repetitions. If removed, the
repetitions in soilphys of each profile must match in their structure
exactly.}

\item{y}{The result of the bootstrap model.}
}
\value{
x with added columns DELTA_flux and DELTA_prod as an estimate
of the error of of the corresponding columns in the same units.
}
\description{
Estimate model uncertainty
}
\section{General procedure}{
\code{\link[=bootstrap_error]{bootstrap_error()}} is mostly a wrapper around two functions that can also be
run separately.

In \code{\link[=make_bootstrap_model]{make_bootstrap_model()}}, for \code{sample_from = "gasdata"} the
\code{gasdata} concentration data is resampled for every depth and profile
a total number of \code{n_samples}. This is done by randomly sampling the
observations at each depth without changing the number of observations but
while allowing replacing. If \code{rep_cols} are given, these columns are
removed from the \code{id_cols} and the resulting profiles combined as one.

For \code{sample_from = "soilphys"}, the \code{soilphys} data is combined
using the \code{rep_cols} as repetitions. Among every remaining profile and
depth, one observation across all repetitions is chosen for each of
\code{n_samples}. \code{sample_from = "both"} applies both methods above.
Each newly sampled profile is identifiable by the
added \code{bootstrap_id} column which is also added to \code{id_cols}.

After this new model is run again, the bootstap error is calculated in
\code{\link[=calculate_bootstrap_error]{calculate_bootstrap_error()}}. This is the standard deviation of the
production and flux parameters across all bootstrapped model runs and is
calculated for each profile and layer of the original model, or for each
distinct profile in the new model without \code{rep_cols}.
These are returned together with the mean values of \code{prod}, \code{flux}
and \code{F0} across all runs in the \code{PROFLUX} data.frame and can
thereby be extracted by \code{\link[=efflux]{efflux()}} and \code{\link[=production]{production()}}.
}

\section{Artificial observations in gasdata}{
If there are not enough observations per depth (e.g.) because there is only
one measurement per depth, it is possible to create artificial observations
by providing \code{n_replicates} and \code{sd_x_ppm}. Here, every depth of
every profile is first averaged to its mean (redundant if there is only one
observation). Then, a random dataset of \code{n_replicates} observations
is generated that is normally distributed around the mean with a standard
deviation (in ppm) of \code{sd_x_ppm}. These observations are then resampled
as described above. Note that this error should be representative of the
sampling error in the field and not the measurement error of the measurement
device, which is much lower.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
PROFLUX <- pro_flux(ConFluxPro::base_dat)
PROFLUX_BSE <- bootstrap_error(PROFLUX)
efflux(PROFLUX_BSE)

PROFLUX_BSE <- bootstrap_error(PROFLUX, n_replicates = 5, sd_x_ppm = 25)
efflux(PROFLUX_BSE)

make_bootstrap_model(PROFLUX) # internal
\dontshow{\}) # examplesIf}
}
