# ColombiAPI - Access Colombian Data via APIs and Curated Datasets
# Version 0.3.1
# Copyright (C) 2025 Renzo Caceres Rossi
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.


#' ColombiAPI: Access Colombian Data via APIs and Curated Datasets
#'
#' \if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}
#'
#' Access Colombian Data via APIs and Curated Datasets.
#'
#' @name ColombiAPI
#' @aliases ColombiAPI-package
#' @title ColombiAPI: Access Colombian Data via APIs and Curated Datasets
#' @description {
#' This package provides a comprehensive interface to access diverse public data about Colombia through multiple APIs and curated datasets. The package integrates four different APIs: API-Colombia for Colombian-specific data including geography, culture, tourism, and government information; World Bank API  for economic and demographic indicators; Nager.Date for public holidays; and REST Countries API for general country information. Additionally, ColombiAPI includes curated datasets covering Bogota air stations, business and holiday dates, public schools, Colombian coffee exports, cannabis licenses, Medellin rainfall, malls in Bogota, as well as datasets on indigenous languages, student admissions and school statistics, forest liana mortality and more.
#' }
#' @seealso {
#' Useful links:
#' \itemize{
#'   \item \url{https://github.com/lightbluetitan/colombiapi}
#' }
#' }
#' @author {
#' \strong{Maintainer}: Renzo Caceres Rossi \email{arenzocaceresrossi@gmail.com}
#' }
'_PACKAGE'
