---
title: 'ClimMobTools: API Client for the ClimMob Platform'
tags:
- citizen science
- data-driven agriculture
- experimental agriculture
- participatory research
- R
- reproducibility
authors:
  - name: Kauê de Sousa
    orcid: 0000-0002-7571-7845
    affiliation: "1, 2"
  - name: Jacob van Etten
    orcid: 0000-0001-7554-2558
    affiliation: 1
affiliations:
  - name: Digital Inclusion, Bioversity International, Montpellier, France
    index: 1
  - name: Department of Agricultural Sciences, Inland Norway University of Applied Sciences, Hamar, Norway
    index: 2
citation_author: de Sousa et. al.
year: 2023
bibliography: paper.bib
output: rticles::joss_article
journal: JOSS
---

# Summary

Abiotic factors play an important role in most ecological and crop systems that depend on certain levels of temperature, light and precipitation to initiate important physiological events [@PlantEcology]. Understanding how these factors drive the physiological processes is a key approach to provide recommendations for adaptation and biodiversity conservation in applied ecology studies. The package `climatrends` aims to provide the methods in R [@RCoreTeam] to compute precipitation and temperature indices that serve as input for climate and crop models [@vanEtten2019; @Kehel2016], trends in climate change [@Aguilar2005; @deSousa2018] and applied ecology [@Prentice1992; @YLiu2018].

# Statement of need

Reproducibility, the ability to repeat the analysis, and replicability, the ability to repeat an experiment [@Stevens2017], are key to performing collaborative scientific research [@Powers2019; @Munafo2017]. It allows scientists to re-perform analysis after a long hiatus and peers to validate analysis and get new insights using original or new data. This is still a gap in most of the studies in agriculture and ecology. `climatrends` addresses this specific issue. The package originates from a set of scripts to compute climate indices in our previous studies [@deSousa2018; @vanEtten2019]. Building up on the interest in expanding the analysis to other regions and to enable reproducible and replicable studies among different research groups within the CGIAR (https://www.cgiar.org) and partner institutions we developed `climatrends`. Most of the package functions take into account the heterogeneity of testing sites (locations), dates and seasons, a common characteristic of decentralized agricultural trials [@vanEtten2019]. 

# Application 


# Further development


# Acknowledgements

This work was supported by The Nordic Joint Committee for Agricultural and Food Research (grant 202100-2817). Additional support was provided by the projects Accelerated Varietal Improvement and Seed Systems in Africa (AVISA, INV-009649) and 1000FARMS (INV-031561) supported by the Bill & Melinda Gates Foundation. The views expressed in this document cannot be taken to reflect the official opinions of these organizations.

# References

<div id="refs"></div>

