% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCharacterization.R
\name{loadCharacterizationSettings}
\alias{loadCharacterizationSettings}
\title{Load the characterization settings previously saved as a json file}
\usage{
loadCharacterizationSettings(fileName)
}
\arguments{
\item{fileName}{The location of the the json settings}
}
\value{
Returns the json settings as an R object
}
\description{
This function converts the json file back into an R object
}
\details{
Input the directory containing the 'characterizationSettings.json' file and load the settings into R
}
\examples{
# example code

setPath <- file.path(tempdir(), 'charSet.json')

drSet <- createDechallengeRechallengeSettings(
  targetIds = c(1,2),
  outcomeIds = 3
)

cSet <- createCharacterizationSettings(
  dechallengeRechallengeSettings = drSet
)

saveCharacterizationSettings(
  settings = cSet,
  fileName = setPath
)

setting <- loadCharacterizationSettings(setPath)


}
\seealso{
Other LargeScale: 
\code{\link{createCharacterizationSettings}()},
\code{\link{runCharacterizationAnalyses}()},
\code{\link{saveCharacterizationSettings}()}
}
\concept{LargeScale}
