% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveModel.R
\name{loadModel}
\alias{loadModel}
\title{Load model.rda file}
\usage{
loadModel(directory)
}
\arguments{
\item{directory}{Directory where the model was saved}
}
\value{
No value is returned. Model object is loaded in global environment.
}
\description{
Loads a previously saved model from disk.
}
\details{
Note, the names of model, engine, and host objects will
be appended with name of model directory when reloading \code{model.rda} file
to global environment.
}
\examples{
\donttest{
TempDir <- tempdir()
model <- emaxmodel(
  checkBaseline = TRUE,
  checkFractional = TRUE,
  checkInhibitory = TRUE,
  data = pkpdData,
  ID = "ID",
  C = "CObs",
  EObs = "EObs",
  modelName = "model",
  workingDir = TempDir
)

saveModel(model)

loadModel(TempDir)
}

}
\keyword{internal}
