% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\name{extraDoseLines}
\alias{extraDoseLines}
\title{Return extra dose lines}
\usage{
extraDoseLines(model)
}
\arguments{
\item{model}{Model object}
}
\value{
List of extra dose information
}
\description{
Use to return extra dose lines for model object
}
\examples{
data <- pkData
data$II <- 24
data$ADDL <- 1

model <-
pkmodel(
  parameterization = "Clearance",
  numCompartments = 2,
  data = data,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir())
addDoseCycle(
  model,
  name = "A1",
  amount = 30000,
  II = 24,
  type = "ADDL",
  colName = "ADDL")

extraDoseLines(model)

}
