% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.r
\docType{class}
\name{NlmeVpcParams-class}
\alias{NlmeVpcParams-class}
\alias{NlmeVpcParams}
\title{Arguments for VPC runs}
\arguments{
\item{numReplicates}{Integer; Number of replicates to simulate the model}

\item{seed}{Integer; Random number generator seed}

\item{predCorrection}{Character; Type of correction to use when calculating a prediction-corrected observation.
Options are \code{"none", "proportional", "additive"}.
This option is ignored for discontinuous observed variables (categorical, count, and time-to-event).}

\item{predVarCorr}{Logical; Set to \code{TRUE} to use Prediction Variance Correction.
Only applicable to the case where \code{predCorrection} is set to either
\code{"proportional"} or \code{"additive"}.}

\item{outputPRED}{Logical; Set to \code{TRUE} to include population prediction (PRED) results
for continuous observed variables in output.}

\item{stratifyColumns}{Character or character vector; Names of categorical covariates (up to 3)
used to stratify modeling simulation results.}

\item{observationVars}{NlmeObservationVar class instance or list of these
instances}

\item{simulationTables}{Optional list of simulation tables.
\code{NlmeSimTableDef} class instance or a list of such instances. Could be
generated by \code{tableParams} wrapper function or by \code{NlmeSimTableDef} class instance
initializing directly.}
}
\description{
Class initializer for arguments of visual predictive check (VPC) runs
}
\examples{
\dontrun{
model <- pkmodel(
  parameterization = "Clearance",
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir()
  )

# Define the host
host <- hostParams(parallelMethod = "NONE",
                   hostName = "local",
                   numCores = 1,
                   sharedDirectory = tempdir())
job <- fitmodel(model,
                hostPlatform = host)

# View estimation results
print(job)

finalModelVPC <- copyModel(model,
                           acceptAllEffects = TRUE,
                           modelName = "model_VPC",
                           workingDir = tempdir())

# View the model
print(finalModelVPC)

# Set up VPC arguments to have PRED outputted to simulation output dataset "predout.csv"
vpcSetup <- NlmeVpcParams(outputPRED = TRUE)

# Run VPC using the default host, default values for the relevant NLME engine arguments
finalVPCJob <-
  vpcmodel(model = finalModelVPC, vpcParams = vpcSetup, )

}

}
\seealso{
\code{\link{tableParams}, \link{NlmeSimTableDef}, \link{NlmeObservationVar}}
}
\keyword{internal}
