% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{psi_get}
\alias{psi_get}
\title{Generate a Fourier Cosine Basis Matrix for Log-Spectral Modeling}
\usage{
psi_get(k0, frq)
}
\arguments{
\item{k0}{Number of cepstral basis function.}

\item{frq}{A vector of frequencies in \code{[0,1]}.}
}
\value{
A \code{k0 x length(frq)} matrix of basis function.
}
\description{
Constructs a matrix of Fourier cosine basis functions evaluated at a given frequency grid.
Used in cepstral smoothing of log-spectra.
}
\examples{
set.seed(123)
frq<-seq(0,1, length.out=5)
psi<-psi_get(k0=3, frq)
}
