# CausalImpact

<!-- badges: start -->
[![R-CMD-check](https://github.com/google/CausalImpact/workflows/R-CMD-check/badge.svg)](https://github.com/google/CausalImpact/actions)
[![Codecov test coverage](https://codecov.io/gh/google/CausalImpact/branch/master/graph/badge.svg)](https://app.codecov.io/gh/google/CausalImpact?branch=master)
<!-- badges: end -->

## An R package for causal inference using Bayesian structural time-series models

This R package implements an approach to estimating the causal effect of a
designed intervention on a time series. For example, how many additional daily
clicks were generated by an advertising campaign? Answering a question like this
can be difficult when a randomized experiment is not available. The package aims
to address this difficulty using a structural Bayesian time-series model to
estimate how the response metric might have evolved after the intervention if
the intervention had not occurred.

As with all approaches to causal inference on non-experimental data, valid
conclusions require strong assumptions. The CausalImpact package, in particular,
assumes that the outcome time series can be explained in terms of a set of
control time series that were themselves not affected by the intervention.
Furthermore, the relation between treated series and control series is assumed
to be stable during the post-intervention period. Understanding and checking
these assumptions for any given application is critical for obtaining valid
conclusions.

For Python users we recommend the implementation in
[TFP CausalImpact](https://github.com/google/tfp-causalimpact), contributed by
Colin Carroll, David Moore, Jacob Burnim, Kyle Loveless, and Susanna Makela. The
Python implementation uses TensorFlow Probability and has been designed to
produce results close to those of the R package. Some differences are expected
given the nature of randomized algorithms.

## Installation

```r
install.packages("CausalImpact")
library(CausalImpact)
```

## Getting started

[Video tutorial](https://www.youtube.com/watch?v=GTgZfCltMm8)

[Documentation and examples](https://google.github.io/CausalImpact/CausalImpact.html)

## Further resources

*   Manuscript:
    [Brodersen et al., Annals of Applied Statistics (2015)](https://research.google/pubs/inferring-causal-impact-using-bayesian-structural-time-series-models/)

*   For questions on the statistics behind CausalImpact:
    [Cross Validated](https://stats.stackexchange.com/questions/tagged/causalimpact)

*   For questions on how to use the CausalImpact R package:
    [Stack Overflow](https://stackoverflow.com/questions/tagged/causal-inference)

*   [Bug reports](https://github.com/google/CausalImpact/issues)

*   Python version:
    [TFP CausalImpact](https://github.com/google/tfp-causalimpact)
