% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_create.R
\name{template_create}
\alias{template_create}
\title{Create a template to fill the CRediT author statement.}
\usage{
template_create(authors, file, roles = roles_get())
}
\arguments{
\item{authors}{A character vector with all the authors to be included in the
statement.}

\item{file}{If a path is provided, the template is saved as a csv for excel}

\item{roles}{A character vector with the roles to be included in the
statement. If NULL, it uses all the roles defined in the CRediT author
statement.}
}
\value{
A dataframe with a row for each author and a column for each role,
filled with zeros.
}
\description{
Create a template to fill the CRediT author statement.
(\url{https://credit.niso.org}). The template is a table where the authors
are the rows and the columns are the roles.
}
\details{
The dataframe can be edited in R or, if file is provided, it is
exported to a csv to be edited manually in your preferred csv editor. The
csv is created to be compatible with Microsoft Excel, since it is the most
popular spreadsheet software among scientists. Therefore, it is separated
by semicolon.
}
\examples{
template_create(authors = c("Josep Maria", "Jane Doe"))
}
