% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vect_to_fac}
\alias{vect_to_fac}
\title{Convert vectorized output of (a)cmtf to a Fac list object with all loadings per mode.}
\usage{
vect_to_fac(vect, Z, sortComponents = FALSE)
}
\arguments{
\item{vect}{Vectorized output of (a)cmtf}

\item{Z}{Original Z input object (see \link{setupCMTFdata}).}

\item{sortComponents}{Sort the order of the components by variation explained (default FALSE).}
}
\value{
Fac: list object with all loadings in all components per mode, ordered the same way as Z$modes.
}
\description{
Convert vectorized output of (a)cmtf to a Fac list object with all loadings per mode.
}
\examples{
set.seed(123)
A = array(rnorm(108*2), c(108, 2))
B = array(rnorm(100*2), c(100, 2))
C = array(rnorm(10*2), c(10, 2))
D = array(rnorm(100*2), c(100,2))
E = array(rnorm(10*2), c(10,2))

df1 = reinflateTensor(A, B, C)
df2 = reinflateTensor(A, D, E)
datasets = list(df1, df2)
modes = list(c(1,2,3), c(1,4,5))
Z = setupCMTFdata(datasets, modes, normalize=FALSE)

result = cmtf_opt(Z, 2, initialization="random", max_iter = 2)
Fac = vect_to_fac(result$par, Z)
}
