% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmtf_fun.R
\name{cmtf_fun}
\alias{cmtf_fun}
\title{Calculate function value of CMTF}
\usage{
cmtf_fun(x, Z, manual = FALSE)
}
\arguments{
\item{x}{Vectorized parameters of the CMTF model.}

\item{Z}{Z object as generated by \code{\link[=setupCMTFdata]{setupCMTFdata()}}.}

\item{manual}{Manual calculation of each loss term (default FALSE)}
}
\value{
Function value of the CMTF loss value if manual=FALSE, otherwise a vector of the loss values per term.
}
\description{
Calculate function value of CMTF
}
\examples{
A = array(rnorm(108*2), c(108, 2))
B = array(rnorm(100*2), c(100, 2))
C = array(rnorm(10*2), c(10, 2))
D = array(rnorm(100*2), c(100,2))
E = array(rnorm(10*2), c(10,2))

df1 = reinflateTensor(A, B, C)
df2 = reinflateTensor(A, D, E)
datasets = list(df1, df2)
modes = list(c(1,2,3), c(1,4,5))
Z = setupCMTFdata(datasets, modes, normalize=FALSE)

init = initializeCMTF(Z, 2, output="vect")
f = cmtf_fun(init, Z)
}
