% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_statistics.R
\name{n_boundaries}
\alias{n_boundaries}
\title{Number of boundaries}
\usage{
n_boundaries(x, null_distrib)
}
\arguments{
\item{x}{A SpatRaster object with boundary elements.}

\item{null_distrib}{A list of probability functions output from boundary_null_distrib().}
}
\value{
The number of subgraphs in the raster and a p-value.
}
\description{
Statistical test the for number of subgraphs, or sets of contiguous boundary elements, in the data.
}
\examples{
\donttest{
data(T.cristatus)
T.cristatus <- terra::rast(T.cristatus_matrix, crs = T.cristatus_crs)
terra::ext(T.cristatus) <- T.cristatus_ext

T.crist_boundaries <- define_boundary(T.cristatus, cat = TRUE)
T.crist_bound_null <- boundary_null_distrib(T.cristatus, cat = TRUE,
n_iterations = 100, model = 'random_cluster')

n_boundaries(T.crist_boundaries, T.crist_bound_null)
}

}
\references{
Jacquez, G.M., Maruca,I S. & Fortin M.-J. (2000) From fields to objects: A review of geographic boundary analysis. Journal of Geographical Systems, 3, 221, 241.
}
\author{
Amy Luo
}
