% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{getImpRf}
\alias{getImpRf}
\alias{getImpRfZ}
\alias{getImpRfGini}
\alias{getImpRfRaw}
\title{ranger Random Forest importance adapters}
\usage{
getImpRfZ(x, y, ntree = 500, num.trees = ntree, ...)

getImpRfGini(x, y, ntree = 500, num.trees = ntree, ...)

getImpRfRaw(x, y, ntree = 500, num.trees = ntree, ...)
}
\arguments{
\item{x}{data frame of predictors including shadows.}

\item{y}{response vector.}

\item{ntree}{Number of trees in the forest; copied into \code{\link[ranger]{ranger}}'s native num.trees, put to retain transparent compatibility with randomForest.}

\item{num.trees}{Number of trees in the forest, as according to \code{\link[ranger]{ranger}}'s nomenclature. If not given, set to \code{ntree} value. If both are given, \code{num.trees} takes precedence.}

\item{...}{parameters passed to the underlying \code{\link[ranger]{ranger}} call; they are relayed from \code{...} of \code{\link{Boruta}}.}
}
\description{
Those function is intended to be given to a \code{getImp} argument of \code{\link{Boruta}} function to be called by the Boruta algorithm as an importance source.
\code{getImpRfZ} generates default, normalized permutation importance, \code{getImpRfRaw} raw permutation importance, finally \code{getImpRfGini} generates Gini index importance.
}
\note{
Prior to Boruta 5.0, \code{getImpLegacyRfZ} function was a default importance source in Boruta; see \link{getImpLegacyRf} for more details.
}
