% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{color_mesh}
\alias{color_mesh}
\title{Takes a density vector mapped to standardized coordinates and maps it to a
surface mesh for visualization.}
\usage{
color_mesh(
  surface_mesh,
  template_pts,
  density_vector,
  maxi = NULL,
  mini = NULL,
  export_path,
  color_sel
)
}
\arguments{
\item{surface_mesh}{Mesh object}

\item{template_pts}{Matrix}

\item{density_vector}{Vector}

\item{maxi}{Numeric}

\item{mini}{Numeric}

\item{export_path}{Character}

\item{color_sel}{String}
}
\value{
mesh3d object with added color dimension
}
\description{
Takes a density vector mapped to standardized coordinates and maps it to a
surface mesh for visualization.
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.1/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  landmark_path <- system.file("extdata", "test_femur.mrk.json",
                               package = "BoneDensityMapping")
  landmarks <- import_lmks(landmark_path)
  mapped_coords <- surface_points_template(surface_mesh, landmarks,
                                           no_surface_sliders = 1000)
  dens <- voxel_point_intersect(mapped_coords, nifti,
                                ct_eqn = "linear",
                                ct_params = c(68.4, 1.106))
  colored_mesh <- color_mesh(surface_mesh, mapped_coords, dens)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
