% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richnessPrepR.R
\name{richnessPrepR}
\alias{richnessPrepR}
\title{Prepare occurrence, taxonomy, and checklist data for richness estimation}
\usage{
richnessPrepR(
  data = NULL,
  taxonomyFile = BeeBDC::beesTaxonomy(),
  checklistFile = BeeBDC::beesChecklist(),
  curveFunction = function(x) (228.7531 * x * x^-log(12.1593)),
  sampleSize = 10000,
  countryColumn = "country_suggested",
  limitGlobal = NULL,
  outPath = tempdir()
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input. Needs to include the
\code{scientificName} column and a "country" column (see \code{countryColumn})}

\item{taxonomyFile}{A data frame or tibble. The taxonomy file to use.
Default = \code{\link[=beesTaxonomy]{beesTaxonomy()}} but see \code{\link[=taxadbToBeeBDC]{taxadbToBeeBDC()}} for other taxa.}

\item{checklistFile}{A data frame or tibble. The taxonomy to use.
Default = \code{\link[=beesChecklist]{beesChecklist()}}; use this as a template to convert other taxa checklists.}

\item{curveFunction}{A function. The mathematical function that describes the curve used to
randomly sample from in order to fill empty sample sizes for species present in the checklist
but not present in the occurrence dataset. Default is \code{function(x) (228.7531 * x * x^-log(12.1593))},
which is taken from the paper "How many bee species are there? A quantitative global estimate" by
Dorey et al. Models can be fit using \code{\link[mosaic:fitModel]{mosaic::fitModel()}}.}

\item{sampleSize}{Numeric. The size of the sample randomly drawn from the provided curve.
See \code{curveFunction}. Default = 10000.}

\item{countryColumn}{Character. The column from which country names should be sought.}

\item{limitGlobal}{Character vector. A character vector of the countries to filter the data to
in order limit the extent of the global-level analysis. Defualt = NULL.}

\item{outPath}{Character. The output path where the curve plot (curvePlot.pdf) and the output
Rdata (richnessInputs.Rda) file will be saved. Default = \code{tempdir()}.}
}
\value{
Saves an Rdata file with the data needed to feed into the \code{\link[=richnessEstimateR]{richnessEstimateR()}}
function. The \code{\link[=richnessEstimateR]{richnessEstimateR()}} function will then
use iChao and/or iNEXT to estimate species richness for countries, continents, and the globe.
Also returns the RData file to the environment.
}
\description{
Takes your occurrence dataset along with a taxonomy and checklist in order to produce
a file that's ready to be passed into the \code{\link[=richnessEstimateR]{richnessEstimateR()}} function in order to
estimate species richness using
iChao and iNEXT (hill numbers) for countries, continents, or the entire globe.
}
\examples{

\dontrun{
data(beesCountrySubset)

estimateDataExample <- richnessPrepR(
  data = beesCountrySubset,
  # Download the taxonomy
  taxonomyFile = BeeBDC::beesTaxonomy(),
  # Download the checklist
  checklistFile = BeeBDC::beesChecklist(),
  curveFunction = function(x) (228.7531 * x * x^-log(12.1593)),
  sampleSize = 10000,
  countryColumn = "country_suggested",
  limitGlobal = NULL,
  outPath = tempdir()
)
}
}
\seealso{
\code{\link[=countryHarmoniseR]{countryHarmoniseR()}} to harmonise country names based on a short list.
}
