% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirMaker.R
\name{dirMaker}
\alias{dirMaker}
\title{Set up global directory paths and create folders}
\usage{
dirMaker(
  RootPath = RootPath,
  ScriptPath = NULL,
  DataPath = NULL,
  DataSubPath = "/Data_acquisition_workflow",
  DiscLifePath = NULL,
  OutPath = NULL,
  OutPathName = "Output",
  Report = TRUE,
  Check = TRUE,
  Figures = TRUE,
  Intermediate = TRUE,
  RDoc = NULL,
  useHere = TRUE
)
}
\arguments{
\item{RootPath}{A character String. The \code{RootPath} is the base path for your project, and all
other paths should ideally be located within the \code{RootPath}. However, users may specify paths not
contained in the RootPath}

\item{ScriptPath}{A character String. The \code{ScriptPath} is the path to any additional functions
that you would like to read in for use with BeeBDC.}

\item{DataPath}{A character string. The path to the folder containing bee occurrence data
to be flagged and/or cleaned}

\item{DataSubPath}{A character String. If a \code{DataPath} is not provided, this will be used as the \code{DataPath}
folder name within the \code{RootPath.} Default is "/Data_acquisition_workflow"}

\item{DiscLifePath}{A character String. The path to the folder which contains data from Ascher
and Pcikering's Discover Life website.}

\item{OutPath}{A character String. The path to the folder where output data will be saved.}

\item{OutPathName}{A character String. The name of the \code{OutPath} subfolder located within the
\code{RootPath.} Default is "Output".}

\item{Report}{Logical. If TRUE, function creates a "Report" folder within the OutPath-defined
folder. Default = TRUE.}

\item{Check}{Logical. If TRUE, function creates a "Check" folder within the OutPath-defined
folder. Default = TRUE.}

\item{Figures}{Logical. If TRUE, function creates a "Figures" folder within the OutPath-defined
folder. Default = TRUE.}

\item{Intermediate}{Logical. If TRUE, function creates a "Intermediate" folder within the
OutPath-defined folder in which to save intermediate datasets. Default = TRUE.}

\item{RDoc}{A character String. The path to the current script or report, relative to the project
root. Passing an absolute path raises an error. This argument is used by \code{\link[here:i_am]{here::i_am()}} and incorrectly
setting this may result in \code{bdc} figures being saved to your computer's root directory}

\item{useHere}{Logical. If TRUE, dirMaker will use \code{\link[here:i_am]{here::i_am()}} to declare the relative path
to 'RDoc'. This is aimed at preserving some functionality with where bdc saves summary figures
and tables. Default = TRUE.}
}
\value{
Results in the generation of a list containing the BeeBDC-required directories in your global
environment. This function should be run at the start of each session. Additionally, this
function will create the BeeBDC-required folders if they do not already exist in the supplied
directory
}
\description{
This function sets up a directory for saving outputs (i.e. data, figures) generated through the
use of the BeeBDC package, if the required folders do not already exist.
}
\examples{
  # load dplyr
  library(dplyr)
# Standard/basic usage:
RootPath <- tempdir()
dirMaker(
RootPath = RootPath,
# Input the location of the workflow script RELATIVE to the RootPath
RDoc = NULL,
useHere = FALSE) \%>\%
  # Add paths created by this function to the environment()
  list2env(envir = environment())  

# Custom OutPathName provided
  dirMaker(
 RootPath = RootPath,
 # Set some custom OutPath info
 OutPath = NULL,
 OutPathName = "T2T_Output",
 # Input the location of the workflow script RELATIVE to the RootPath
 RDoc = NULL,
 useHere = FALSE) \%>\%
   # Add paths created by this function to the environment()
   list2env(envir = environment())  
 # Set the working directory

# Further customisations are also possible
dirMaker(
  RootPath = RootPath,
  ScriptPath = "...path/Bee_SDM_paper/BDC_repo/BeeBDC/R",
  DiscLifePath = "...path/BDC_repo/DiscoverLife_Data",
  OutPathName = "AsianPerspective_Output",
  # Input the location of the workflow script RELATIVE to the RootPath
  RDoc = NULL,
  useHere = FALSE) \%>\%
  # Add paths created by this function to the environment()
  list2env(envir = environment())  



}
