/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.BaseEdge;
import jebl.evolution.trees.BaseNode;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.AttributableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleRootedTree
implements RootedTree {
    private AttributableHelper helper = null;
    protected SimpleRootedNode rootNode = null;
    protected final Set<Node> internalNodes = new LinkedHashSet<Node>();
    private final Set<Node> externalNodes = new LinkedHashSet<Node>();
    private final Set<Taxon> taxa = new LinkedHashSet<Taxon>();
    private Map<Taxon, Node> externalNodeMap = null;
    private boolean heightsKnown = false;
    private boolean lengthsKnown = false;
    private boolean hasHeights = false;
    private boolean hasLengths = false;
    private boolean conceptuallyUnrooted = false;

    public SimpleRootedTree() {
    }

    public SimpleRootedTree(RootedTree tree) {
        this.createNodes(tree, tree.getRootNode());
    }

    public SimpleRootedTree(RootedTree tree, Map<Node, Node> nodeMapping) {
        this.createNodes(tree, tree.getRootNode(), nodeMapping);
        this.setConceptuallyUnrooted(tree.conceptuallyUnrooted());
    }

    public SimpleRootedTree(Tree tree, Node ingroupNode, Node outgroupNode, double ingroupBranchLength) throws Graph.NoEdgeException {
        ArrayList<Node> children = new ArrayList<Node>();
        Node node1 = this.createNodes(tree, outgroupNode, ingroupNode);
        this.setLength(node1, ingroupBranchLength);
        children.add(node1);
        Node node2 = this.createNodes(tree, ingroupNode, outgroupNode);
        this.setLength(node2, Math.max(tree.getEdgeLength(ingroupNode, outgroupNode) - ingroupBranchLength, 0.0));
        children.add(node2);
        this.createInternalNode(children);
    }

    public Node createNodes(RootedTree tree, Node node) {
        return this.createNodes(tree, node, (Map<Node, Node>)null);
    }

    private Node createNodes(RootedTree tree, Node node, Map<Node, Node> nodeMapping) {
        Node newNode;
        if (tree.isExternal(node)) {
            newNode = this.createExternalNode(tree.getTaxon(node));
        } else {
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node child : tree.getChildren(node)) {
                children.add(this.createNodes(tree, child, nodeMapping));
            }
            newNode = this.createInternalNode(children);
        }
        if (nodeMapping != null) {
            nodeMapping.put(node, newNode);
        }
        for (Map.Entry<String, Object> e : node.getAttributeMap().entrySet()) {
            newNode.setAttribute(e.getKey(), e.getValue());
        }
        this.setHeight(newNode, tree.getHeight(node));
        return newNode;
    }

    public Node createNodes(Tree tree, Node parent, Node child) throws Graph.NoEdgeException {
        Node newNode = null;
        if (tree.isExternal(child)) {
            newNode = this.createExternalNode(tree.getTaxon(child));
        } else {
            List<Node> adjacencies = tree.getAdjacencies(child);
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node child2 : adjacencies) {
                if (child2 == parent) continue;
                children.add(this.createNodes(tree, child, child2));
            }
            newNode = this.createInternalNode(children);
        }
        this.setLength(newNode, tree.getEdgeLength(parent, child));
        return newNode;
    }

    public Node createExternalNode(Taxon taxon) {
        if (this.getTaxa().contains(taxon)) {
            throw new IllegalArgumentException("duplicate taxon " + taxon.getName());
        }
        SimpleRootedNode node = new SimpleRootedNode(taxon);
        this.externalNodes.add(node);
        this.taxa.add(taxon);
        return node;
    }

    public SimpleRootedNode createInternalNode(List<? extends Node> children) {
        SimpleRootedNode node = new SimpleRootedNode(children);
        for (Node node2 : children) {
            ((SimpleRootedNode)node2).setParent(node);
        }
        this.internalNodes.add(node);
        this.rootNode = node;
        return node;
    }

    public void deleteInternalNode(Node node) {
        if (!(node instanceof SimpleRootedNode)) {
            throw new IllegalArgumentException("Node must be a node in this tree");
        }
        SimpleRootedNode simpleRootedNode = (SimpleRootedNode)node;
        if (!this.internalNodes.contains(node)) {
            throw new IllegalArgumentException("Not an internal node");
        }
        if (this.rootNode == node) {
            this.rootNode = (SimpleRootedNode)this.getChildren(node).get(0);
        }
        this.internalNodes.remove(node);
        SimpleRootedNode parentNode = (SimpleRootedNode)simpleRootedNode.getParent();
        if (parentNode != null) {
            parentNode.removeChild(node);
        }
        for (Node child : this.getChildren(node)) {
            ((SimpleRootedNode)child).setParent(parentNode);
            if (parentNode == null) continue;
            parentNode.addChild((SimpleRootedNode)child);
        }
    }

    public Node addNode(Node node) {
        SimpleRootedNode rootedNode = (SimpleRootedNode)node;
        Edge edge = rootedNode.getEdge();
        if (edge == null) {
            throw new IllegalArgumentException("The node must have a parent");
        }
        return this.addNode(edge);
    }

    public Node addNode(Edge edge) {
        SimpleRootedNode childNode;
        SimpleRootedNode parentNode;
        Node[] edgeNodes = this.getNodes(edge);
        if (edgeNodes == null) {
            throw new IllegalArgumentException("The edge must exist on the tree");
        }
        double edgeLength = edge.getLength();
        if (this.getChildren(edgeNodes[0]).contains(edgeNodes[1])) {
            parentNode = (SimpleRootedNode)edgeNodes[0];
            childNode = (SimpleRootedNode)edgeNodes[1];
        } else {
            parentNode = (SimpleRootedNode)edgeNodes[1];
            childNode = (SimpleRootedNode)edgeNodes[0];
        }
        SimpleRootedNode newNode = new SimpleRootedNode(Arrays.asList(childNode));
        newNode.setLength(edgeLength / 2.0);
        newNode.setHeight((childNode.getHeight() + parentNode.getHeight()) / 2.0);
        childNode.setLength(edgeLength / 2.0);
        childNode.setParent(newNode);
        parentNode.removeChild(childNode);
        parentNode.addChild(newNode);
        return newNode;
    }

    public void swapNodes(Node n, int i0, int i1) {
        ((SimpleRootedNode)n).swapChildren(i0, i1);
    }

    public void setHeight(Node node, double height) {
        this.lengthsKnown = false;
        this.heightsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((SimpleRootedNode)node).setHeight(height);
    }

    public void setLength(Node node, double length) {
        this.heightsKnown = false;
        this.lengthsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((SimpleRootedNode)node).setLength(length);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return new ArrayList<Node>(((SimpleRootedNode)node).getChildren());
    }

    @Override
    public boolean hasHeights() {
        return this.hasHeights;
    }

    @Override
    public double getHeight(Node node) {
        if (!this.hasHeights) {
            throw new IllegalArgumentException("This tree has no node heights");
        }
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        return ((SimpleRootedNode)node).getHeight();
    }

    @Override
    public boolean hasLengths() {
        return this.hasLengths;
    }

    @Override
    public double getLength(Node node) {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("This tree has no branch lengths");
        }
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        return ((SimpleRootedNode)node).getLength();
    }

    @Override
    public Node getParent(Node node) {
        if (!(node instanceof SimpleRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode");
        }
        return ((SimpleRootedNode)node).getParent();
    }

    public Edge getParentEdge(Node node) {
        if (!(node instanceof SimpleRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode");
        }
        return ((SimpleRootedNode)node).getEdge();
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return this.externalNodes;
    }

    @Override
    public Set<Node> getInternalNodes() {
        return new LinkedHashSet<Node>(this.internalNodes);
    }

    @Override
    public Set<Taxon> getTaxa() {
        return this.taxa;
    }

    @Override
    public Taxon getTaxon(Node node) {
        if (!(node instanceof SimpleRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode.  It is an instance of " + node.getClass().getName());
        }
        return ((SimpleRootedNode)node).getTaxon();
    }

    @Override
    public boolean isExternal(Node node) {
        if (!(node instanceof SimpleRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode.  It is an instance of " + node.getClass().getName());
        }
        return ((SimpleRootedNode)node).getChildren().size() == 0;
    }

    @Override
    public Node getNode(Taxon taxon) {
        if (this.externalNodeMap == null) {
            this.externalNodeMap = new LinkedHashMap<Taxon, Node>();
            for (Node node : this.getExternalNodes()) {
                this.externalNodeMap.put(((SimpleRootedNode)node).getTaxon(), node);
            }
        }
        return this.externalNodeMap.get(taxon);
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        SimpleRootedNode node = (SimpleRootedNode)this.getNode(from);
        if (node == null) {
            throw new IllegalArgumentException("Unknown taxon " + from + "; can't rename to " + to);
        }
        node.setTaxa(to);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Node adjNode : this.getAdjacencies(node)) {
            edges.add(((SimpleRootedNode)adjNode).getEdge());
        }
        return edges;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        return ((SimpleRootedNode)node).getAdjacencies();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((SimpleRootedNode)node1).getParent() == node2) {
            return ((SimpleRootedNode)node1).getEdge();
        }
        if (((SimpleRootedNode)node2).getParent() == node1) {
            return ((SimpleRootedNode)node2).getEdge();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((SimpleRootedNode)node1).getParent() == node2) {
            if (this.heightsKnown) {
                return ((SimpleRootedNode)node2).getHeight() - ((SimpleRootedNode)node1).getHeight();
            }
            return ((SimpleRootedNode)node1).getLength();
        }
        if (((SimpleRootedNode)node2).getParent() == node1) {
            if (this.heightsKnown) {
                return ((SimpleRootedNode)node1).getHeight() - ((SimpleRootedNode)node2).getHeight();
            }
            return ((SimpleRootedNode)node2).getLength();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public Node[] getNodes(Edge edge) {
        for (Node node : this.getNodes()) {
            if (((SimpleRootedNode)node).getEdge() != edge) continue;
            return new Node[]{node, ((SimpleRootedNode)node).getParent()};
        }
        return null;
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(this.internalNodes);
        nodes.addAll(this.getExternalNodes());
        return nodes;
    }

    @Override
    public Set<Edge> getEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((SimpleRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getExternalNodes()) {
            edges.add(((SimpleRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getInternalNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((SimpleRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Node> getNodes(int degree) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            int deg = node.getDegree();
            if (deg != degree) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private void calculateNodeHeights() {
        if (!this.lengthsKnown) {
            throw new IllegalArgumentException("Can't calculate node heights because branch lengths not known");
        }
        this.nodeLengthsToHeights(this.rootNode, 0.0);
        double maxHeight = 0.0;
        for (Node externalNode : this.getExternalNodes()) {
            if (!(((SimpleRootedNode)externalNode).getHeight() > maxHeight)) continue;
            maxHeight = ((SimpleRootedNode)externalNode).getHeight();
        }
        for (Node node : this.getNodes()) {
            ((SimpleRootedNode)node).setHeight(maxHeight - ((SimpleRootedNode)node).getHeight());
        }
        this.heightsKnown = true;
    }

    private void nodeLengthsToHeights(SimpleRootedNode node, double height) {
        double newHeight = height;
        if (node.getLength() > 0.0) {
            newHeight += node.getLength();
        }
        node.setHeight(newHeight);
        for (Node child : node.getChildren()) {
            this.nodeLengthsToHeights((SimpleRootedNode)child, newHeight);
        }
    }

    protected void calculateBranchLengths() {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("Can't calculate branch lengths because node heights not known");
        }
        this.nodeHeightsToLengths(this.rootNode, this.getHeight(this.rootNode));
        this.lengthsKnown = true;
    }

    private void nodeHeightsToLengths(SimpleRootedNode node, double height) {
        double h = node.getHeight();
        node.setLength(h >= 0.0 ? height - h : 1.0);
        for (Node child : node.getChildren()) {
            this.nodeHeightsToLengths((SimpleRootedNode)child, node.getHeight());
        }
    }

    public void setConceptuallyUnrooted(boolean intent) {
        this.conceptuallyUnrooted = intent;
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return this.conceptuallyUnrooted;
    }

    @Override
    public boolean isRoot(Node node) {
        return node == this.rootNode;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleRootedNode
    extends BaseNode {
        private List<Node> children;
        private Taxon taxon;
        private Node parent;
        private double height;
        private double length;
        private Edge edge = null;

        public SimpleRootedNode(Taxon taxon) {
            this.children = Collections.unmodifiableList(new ArrayList());
            this.taxon = taxon;
        }

        public SimpleRootedNode(List<? extends Node> children) {
            this.children = Collections.unmodifiableList(new ArrayList<Node>(children));
            this.taxon = null;
        }

        public void removeChild(Node node) {
            ArrayList<Node> c = new ArrayList<Node>(this.children);
            c.remove(node);
            this.children = Collections.unmodifiableList(c);
        }

        public void addChild(SimpleRootedNode node) {
            ArrayList<Node> c = new ArrayList<Node>(this.children);
            c.add(node);
            node.setParent(this);
            this.children = Collections.unmodifiableList(c);
        }

        public void replaceChildren(List<SimpleRootedNode> nodes) {
            for (SimpleRootedNode n : nodes) {
                n.setParent(this);
            }
            this.children = Collections.unmodifiableList(new ArrayList<SimpleRootedNode>(nodes));
        }

        void swapChildren(int i0, int i1) {
            ArrayList<Node> nc = new ArrayList<Node>(this.children);
            if (i0 < 0 || i0 >= nc.size() || i1 < 0 || i1 >= nc.size()) {
                throw new IllegalArgumentException("Tried to swap children (" + i0 + "," + i1 + ") on node with " + nc.size() + " children");
            }
            Node ni0 = nc.get(i0);
            nc.set(i0, nc.get(i1));
            nc.set(i1, ni0);
            this.children = Collections.unmodifiableList(nc);
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double length) {
            this.length = length;
        }

        @Override
        public int getDegree() {
            return this.children.size() + (this == SimpleRootedTree.this.rootNode ? 0 : 1);
        }

        public void setTaxa(Taxon to) {
            this.taxon = to;
        }

        public Edge getEdge() {
            if (this.edge == null) {
                this.edge = new BaseEdge(){

                    @Override
                    public double getLength() {
                        return SimpleRootedNode.this.length;
                    }

                    @Override
                    public void setAttribute(String name, Object value) {
                        SimpleRootedNode.this.setAttribute(name, value);
                    }

                    @Override
                    public Object getAttribute(String name) {
                        return SimpleRootedNode.this.getAttribute(name);
                    }

                    @Override
                    public void removeAttribute(String name) {
                        SimpleRootedNode.this.removeAttribute(name);
                    }

                    @Override
                    public Set<String> getAttributeNames() {
                        return SimpleRootedNode.this.getAttributeNames();
                    }

                    @Override
                    public Map<String, Object> getAttributeMap() {
                        return SimpleRootedNode.this.getAttributeMap();
                    }
                };
            }
            return this.edge;
        }

        public List<Node> getAdjacencies() {
            ArrayList<Node> adjacencies = new ArrayList<Node>();
            if (this.children != null) {
                adjacencies.addAll(this.children);
            }
            if (this.parent != null) {
                adjacencies.add(this.parent);
            }
            return adjacencies;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }
    }
}

