/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.AttributableImp;
import jebl.evolution.trees.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactRootedTree
extends AttributableImp
implements RootedTree {
    SimpleRootedNode[] nodes;
    short[] parent;
    short[] sons;
    short[] noSons;
    boolean hasHeights;
    boolean hasLengths;
    double[] heights;
    Taxon[] taxa;
    SimpleRootedEdge[] edges;
    private boolean conceptuallyUnrooted = false;
    Map<Short, Map<String, Object>> all = null;

    private boolean hasAttributeMap(short index) {
        return this.all != null && this.all.get(index) != null;
    }

    private Map<String, Object> aMap(short index) {
        Map<String, Object> map;
        if (this.all == null) {
            this.all = new LinkedHashMap<Short, Map<String, Object>>();
        }
        if ((map = this.all.get(index)) == null) {
            map = new LinkedHashMap<String, Object>();
            this.all.put(index, map);
        }
        return map;
    }

    private int nSons(int index) {
        short n = this.noSons[index];
        if ((n & 0x8000) == 0) {
            return n;
        }
        return 0;
    }

    public CompactRootedTree(RootedTree t) {
        this.conceptuallyUnrooted = t.conceptuallyUnrooted();
        int nNodes = t.getNodes().size();
        this.nodes = new SimpleRootedNode[nNodes];
        this.parent = new short[nNodes];
        this.sons = new short[nNodes];
        this.noSons = new short[nNodes];
        this.heights = new double[nNodes];
        this.hasHeights = t.hasHeights();
        this.hasLengths = t.hasLengths();
        this.taxa = new Taxon[t.getTaxa().size()];
        this.edges = null;
        Node rootNode = t.getRootNode();
        ArrayList<Node> level = new ArrayList<Node>();
        ArrayList<Node> nlevel = new ArrayList<Node>();
        level.add(rootNode);
        int iNode = 0;
        int decendentslStart = 1;
        int nTax = 0;
        while (level.size() > 0) {
            nlevel.clear();
            for (Node n : level) {
                int ns = t.getChildren(n).size();
                if (this.hasHeights) {
                    this.heights[iNode] = t.getHeight(n);
                } else if (this.hasLengths) {
                    this.heights[iNode] = iNode == 0 ? 0.0 : t.getLength(n);
                }
                this.nodes[iNode] = new SimpleRootedNode((short)iNode);
                this.sons[iNode] = ns > 0 ? (short)decendentslStart : (short)0;
                for (int l = 0; l < ns; ++l) {
                    this.parent[decendentslStart + l] = (short)iNode;
                }
                decendentslStart += ns;
                if (ns == 0) {
                    assert (t.isExternal(n));
                    this.taxa[nTax] = t.getTaxon(n);
                    ns = (short)(0x8000 | nTax);
                    ++nTax;
                }
                this.noSons[iNode] = ns;
                Map<String, Object> map = n.getAttributeMap();
                if (map.size() > 0) {
                    this.nodes[iNode].getMap().putAll(map);
                }
                for (Node s : t.getChildren(n)) {
                    nlevel.add(s);
                }
                ++iNode;
            }
            level.clear();
            level.addAll(nlevel);
        }
        Map<String, Object> map = t.getAttributeMap();
        if (map.size() > 0) {
            this.getMap().putAll(map);
        }
    }

    @Override
    public List<Node> getChildren(Node node) {
        short index = ((SimpleRootedNode)node).index;
        int nSon = this.nSons(index);
        ArrayList<Node> clist = new ArrayList<Node>(nSon);
        for (int k = this.sons[index]; k < this.sons[index] + nSon; ++k) {
            clist.add(this.nodes[k]);
        }
        return clist;
    }

    @Override
    public boolean hasHeights() {
        return this.hasHeights;
    }

    @Override
    public double getHeight(Node node) {
        assert (this.hasHeights);
        return this.heights[((SimpleRootedNode)node).index];
    }

    @Override
    public boolean hasLengths() {
        return this.hasLengths;
    }

    @Override
    public double getLength(Node node) {
        assert (this.hasLengths);
        short index = ((SimpleRootedNode)node).index;
        if (this.hasHeights) {
            if (index == 0) {
                return 0.0;
            }
            return this.heights[this.parent[index]] - this.heights[index];
        }
        return this.heights[index];
    }

    @Override
    public Node getParent(Node node) {
        short index = ((SimpleRootedNode)node).index;
        return index == 0 ? null : this.nodes[this.parent[index]];
    }

    public Edge getParentEdge(Node node) {
        throw new UnsupportedOperationException("getParentEdge not implemented in CompactRootedTree");
    }

    @Override
    public Node getRootNode() {
        return this.nodes[0];
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return this.conceptuallyUnrooted;
    }

    public void setConceptuallyUnrooted(boolean conceptuallyUnrooted) {
        this.conceptuallyUnrooted = conceptuallyUnrooted;
    }

    @Override
    public boolean isRoot(Node node) {
        return ((SimpleRootedNode)node).index == 0;
    }

    @Override
    public Set<Node> getExternalNodes() {
        LinkedHashSet<Node> n = new LinkedHashSet<Node>();
        for (int i = 0; i < this.nodes.length; ++i) {
            if ((this.noSons[i] & 0x8000) == 0) continue;
            n.add(this.nodes[i]);
        }
        return n;
    }

    @Override
    public Set<Node> getInternalNodes() {
        LinkedHashSet<Node> n = new LinkedHashSet<Node>();
        for (int i = 0; i < this.nodes.length; ++i) {
            if ((this.noSons[i] & 0x8000) != 0) continue;
            n.add(this.nodes[i]);
        }
        return n;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getExternalNodes()) {
            edges.add(this.establishEdge(((SimpleRootedNode)node).index));
        }
        return edges;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getInternalNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(this.establishEdge(((SimpleRootedNode)node).index));
        }
        return edges;
    }

    @Override
    public Set<Taxon> getTaxa() {
        return new LinkedHashSet<Taxon>(Arrays.asList(this.taxa));
    }

    @Override
    public Taxon getTaxon(Node node) {
        short index = ((SimpleRootedNode)node).index;
        if ((this.noSons[index] & 0x8000) != 0) {
            return this.taxa[this.noSons[index] & Short.MAX_VALUE];
        }
        return null;
    }

    @Override
    public boolean isExternal(Node node) {
        return this.nSons(((SimpleRootedNode)node).index) == 0;
    }

    @Override
    public Node getNode(Taxon taxon) {
        int i = Arrays.asList(this.taxa).indexOf(taxon);
        for (int k = 0; k < this.nodes.length; ++k) {
            if (this.noSons[k] != (short)(0x8000 | i)) continue;
            return this.nodes[k];
        }
        return null;
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        for (int n = 0; n < this.taxa.length; ++n) {
            if (!from.equals(this.taxa[n])) continue;
            this.taxa[n] = to;
            break;
        }
    }

    @Override
    public List<Edge> getEdges(Node node) {
        ArrayList<Edge> e = new ArrayList<Edge>();
        short index = ((SimpleRootedNode)node).index;
        if (index != 0) {
            e.add(this.establishEdge(index));
        }
        for (int n = 0; n < this.nSons(index); ++n) {
            short sindex = (short)(this.sons[index] + n);
            e.add(this.establishEdge(sindex));
        }
        return e;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        ArrayList<Node> adjacencies = new ArrayList<Node>();
        short index = ((SimpleRootedNode)node).index;
        int nSon = this.nSons(index);
        short sonStart = this.sons[index];
        for (int n = 0; n < nSon; ++n) {
            adjacencies.add(this.nodes[sonStart + n]);
        }
        if (index != 0) {
            adjacencies.add(this.nodes[this.parent[index]]);
        }
        return adjacencies;
    }

    private Edge establishEdge(short index) {
        if (this.edges == null) {
            this.edges = new SimpleRootedEdge[this.nodes.length];
        }
        if (this.edges[index] == null) {
            this.edges[index] = new SimpleRootedEdge(index);
        }
        return this.edges[index];
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        short index2;
        short index1 = ((SimpleRootedNode)node1).index;
        if (this.parent[index1] == (index2 = ((SimpleRootedNode)node2).index)) {
            index2 = index1;
        } else if (this.parent[index2] != index1) {
            throw new Graph.NoEdgeException();
        }
        return this.establishEdge(index2);
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        short index2;
        short index1 = ((SimpleRootedNode)node1).index;
        if (this.parent[index1] != (index2 = ((SimpleRootedNode)node2).index) && this.parent[index2] != index1) {
            throw new Graph.NoEdgeException();
        }
        return Math.abs(this.heights[index1] - this.heights[index2]);
    }

    @Override
    public Node[] getNodes(Edge edge) {
        Node[] ns = new Node[2];
        short index = ((SimpleRootedEdge)edge).index;
        ns[0] = this.nodes[index];
        ns[1] = this.nodes[this.parent[index]];
        return ns;
    }

    @Override
    public Set<Node> getNodes() {
        return new LinkedHashSet<Node>(Arrays.asList(this.nodes));
    }

    @Override
    public Set<Edge> getEdges() {
        for (int k = 1; k < this.nodes.length; ++k) {
            this.establishEdge((short)k);
        }
        return new LinkedHashSet<Edge>(Arrays.asList(this.edges));
    }

    @Override
    public Set<Node> getNodes(int degree) {
        LinkedHashSet<Node> ns = new LinkedHashSet<Node>();
        for (int k = 1; k < this.nodes.length; ++k) {
            if (degree != this.nSons(k) + 1) continue;
            ns.add(this.nodes[k]);
        }
        if (this.nSons(0) == degree) {
            ns.add(this.nodes[0]);
        }
        return ns;
    }

    @Override
    Map<String, Object> getExistingMap() {
        short index = (short)this.nodes.length;
        if (this.hasAttributeMap(index)) {
            return this.aMap(index);
        }
        return null;
    }

    @Override
    Map<String, Object> getMap() {
        short index = (short)this.nodes.length;
        return this.aMap(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleRootedEdge
    extends AttributableImp
    implements Edge {
        private short index;

        SimpleRootedEdge(short index) {
            this.index = index;
        }

        @Override
        Map<String, Object> getExistingMap() {
            short i = (short)(CompactRootedTree.this.nodes.length + this.index);
            if (CompactRootedTree.this.hasAttributeMap(i)) {
                return CompactRootedTree.this.aMap(i);
            }
            return null;
        }

        @Override
        Map<String, Object> getMap() {
            return CompactRootedTree.this.aMap((short)(CompactRootedTree.this.nodes.length + this.index));
        }

        @Override
        public double getLength() {
            return CompactRootedTree.this.heights[CompactRootedTree.this.parent[this.index]] - CompactRootedTree.this.heights[this.index];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleRootedNode
    extends AttributableImp
    implements Node {
        private short index;

        SimpleRootedNode(short index) {
            this.index = index;
        }

        @Override
        public int getDegree() {
            return CompactRootedTree.this.nSons(this.index) + (this == CompactRootedTree.this.getRootNode() ? 0 : 1);
        }

        @Override
        Map<String, Object> getExistingMap() {
            if (CompactRootedTree.this.hasAttributeMap(this.index)) {
                return CompactRootedTree.this.aMap(this.index);
            }
            return null;
        }

        @Override
        Map<String, Object> getMap() {
            return CompactRootedTree.this.aMap(this.index);
        }
    }
}

