/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.alignments;

import java.util.Map;
import java.util.Set;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.sequences.Utils;
import jebl.evolution.taxa.Taxon;
import jebl.util.AttributableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsensusSequence
implements Sequence {
    private final Taxon taxon;
    private final Alignment source;
    private byte[] sequence = null;
    private final boolean includeAmbiguities;
    private final AttributableHelper attributableHelper = new AttributableHelper();

    public ConsensusSequence(Taxon taxon, Alignment source) {
        this(taxon, source, false);
    }

    public ConsensusSequence(Taxon taxon, Alignment source, boolean includeAmbiguities) {
        this.taxon = taxon;
        this.source = source;
        this.includeAmbiguities = includeAmbiguities;
    }

    public Alignment getSource() {
        return this.source;
    }

    @Override
    public SequenceType getSequenceType() {
        return this.source.getSequenceType();
    }

    @Override
    public String getString() {
        if (this.sequence == null) {
            this.sequence = Utils.getStateIndices(ConsensusSequence.constructConsensus(this.source, this.includeAmbiguities));
        }
        SequenceType sequenceType = this.getSequenceType();
        StringBuilder buffer = new StringBuilder();
        for (byte i : this.sequence) {
            buffer.append(sequenceType.getState(i).getCode());
        }
        return buffer.toString();
    }

    @Override
    public State[] getStates() {
        if (this.sequence == null) {
            this.sequence = Utils.getStateIndices(ConsensusSequence.constructConsensus(this.source, this.includeAmbiguities));
        }
        return this.getSequenceType().toStateArray(this.sequence);
    }

    @Override
    public byte[] getStateIndices() {
        if (this.sequence == null) {
            this.sequence = Utils.getStateIndices(ConsensusSequence.constructConsensus(this.source, this.includeAmbiguities));
        }
        return this.sequence;
    }

    @Override
    public State getState(int site) {
        if (this.sequence == null) {
            this.sequence = Utils.getStateIndices(ConsensusSequence.constructConsensus(this.source, this.includeAmbiguities));
        }
        return this.getSequenceType().getState(this.sequence[site]);
    }

    @Override
    public int getLength() {
        if (this.sequence == null) {
            this.sequence = Utils.getStateIndices(ConsensusSequence.constructConsensus(this.source, this.includeAmbiguities));
        }
        return this.sequence.length;
    }

    public static State[] constructConsensus(Alignment source, boolean includeAmbiguities) {
        State[] consensus = new State[source.getPatterns().size()];
        int i = 0;
        for (Pattern pattern : source.getPatterns()) {
            consensus[i] = pattern.getMostFrequentState(includeAmbiguities);
            ++i;
        }
        return consensus;
    }

    @Override
    public Taxon getTaxon() {
        return this.taxon;
    }

    public int compareTo(Object o) {
        return this.taxon.compareTo(((Sequence)o).getTaxon());
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributableHelper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributableHelper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributableHelper.removeAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributableHelper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.attributableHelper.getAttributeMap();
    }
}

