/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CitationLogHandler;
import dr.util.FileHelpers;
import dr.util.Identifiable;
import dr.util.Pair;
import dr.util.Version;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reference;
import dr.xml.Report;
import dr.xml.Spawnable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    public static final String ID = "id";
    public static final String IDREF = "idref";
    public static final String CONCURRENT = "concurrent";
    public static final String VERSION = "version";
    private Vector<Thread> threads = new Vector();
    protected boolean strictXML;
    protected boolean parserWarnings;
    private final Version version;
    private final Map<String, XMLObjectParser> parserStore = new TreeMap<String, XMLObjectParser>(new ParserComparator());
    private final Map<String, XMLObject> objectStore = new LinkedHashMap<String, XMLObject>();
    private final Map<Pair<String, String>, List<Citation>> citationStore = new LinkedHashMap<Pair<String, String>, List<Citation>>();
    private boolean concurrent = false;
    private XMLObject root = null;
    private boolean verbose = false;

    public XMLParser(boolean bl, boolean bl2, boolean bl3, Version version) {
        this.verbose = bl;
        this.parserWarnings = bl2;
        this.strictXML = bl3;
        this.addXMLObjectParser(new ArrayParser(), false);
        this.addXMLObjectParser(Report.PARSER, false);
        this.version = version;
    }

    public void addXMLObjectParser(XMLObjectParser xMLObjectParser) {
        this.addXMLObjectParser(xMLObjectParser, false);
    }

    public boolean addXMLObjectParser(XMLObjectParser xMLObjectParser, boolean bl) {
        String[] stringArray;
        boolean bl2 = false;
        for (String string : stringArray = xMLObjectParser.getParserNames()) {
            XMLObjectParser xMLObjectParser2 = this.parserStore.get(string);
            if (xMLObjectParser2 != null) {
                if (!bl) {
                    throw new IllegalArgumentException("New parser (" + xMLObjectParser.getParserName() + ") in {" + xMLObjectParser.getReturnType() + "} cannot replace existing parser (" + xMLObjectParser2.getParserName() + ") in {" + xMLObjectParser2.getReturnType() + "}");
                }
                bl2 = true;
            }
            this.parserStore.put(string, xMLObjectParser);
        }
        return bl2;
    }

    public Iterator getParserNames() {
        return this.parserStore.keySet().iterator();
    }

    public XMLObjectParser getParser(String string) {
        return this.parserStore.get(string);
    }

    public Iterator getParsers() {
        return this.parserStore.values().iterator();
    }

    public Iterator getThreads() {
        return this.threads.iterator();
    }

    public void storeObject(String string, Object object) {
        XMLObject xMLObject = new XMLObject(null, null);
        xMLObject.setNativeObject(object);
        this.objectStore.put(string, xMLObject);
    }

    public Object parse(Reader reader, Class clazz) throws IOException, SAXException, XMLParseException, ParserConfigurationException {
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("beast")) {
            this.concurrent = false;
            return this.convert(element, clazz, null, false, true);
        }
        throw new XMLParseException("Unknown root document element, " + element.getTagName());
    }

    public Map<String, XMLObject> parse(Reader reader, boolean bl) throws IOException, SAXException, XMLParseException, ParserConfigurationException {
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new MyErrorHandler());
        Document document = documentBuilder.parse(inputSource);
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("beast")) {
            if (element.hasAttribute(VERSION)) {
                String string = element.getAttribute(VERSION);
                if (this.version != null && Version.Utils.isMoreRecent(string, this.version.getVersion()) && !Boolean.parseBoolean(System.getProperty("ignore.versions"))) {
                    throw new XMLParseException("The version of BEAUti that generated this XML (" + string + ") is more recent than the version of BEAST running it (" + this.version.getVersion() + "). This may be incompatible and cause unpredictable errors.");
                }
            }
        } else {
            throw new XMLParseException("Unknown root document element, " + element.getTagName());
        }
        this.concurrent = false;
        this.root = (XMLObject)this.convert(element, null, null, bl, true);
        return this.objectStore;
    }

    public XMLObject getRoot() {
        return this.root;
    }

    private Object convert(Element element, Class clazz, XMLObject xMLObject, boolean bl, boolean bl2) throws XMLParseException {
        Object object;
        int n;
        int n2 = -1;
        if (element.hasAttribute(IDREF)) {
            boolean bl3;
            String string = element.getAttribute(IDREF);
            if (element.hasAttribute("index")) {
                n2 = Integer.parseInt(element.getAttribute("index"));
            }
            if ((element.getAttributes().getLength() > 1 || element.getChildNodes().getLength() > 1) && n2 == -1) {
                throw new XMLParseException("Object with idref=" + string + " must not have other content or attributes (or perhaps it was not intended to be a reference?).");
            }
            XMLObject xMLObject2 = this.objectStore.get(string);
            if (n2 != -1) {
                if (xMLObject2.getNativeObject() instanceof List) {
                    xMLObject2 = new XMLObject(xMLObject2, n2);
                } else {
                    throw new XMLParseException("Trying to get indexed object from non-list");
                }
            }
            if (xMLObject2 == null) {
                throw new XMLParseException("Object with idref=" + string + " has not been previously declared.");
            }
            if (xMLObject2.getNativeObject() == null) {
                throw new XMLParseException("Object with idref=" + string + " has not been parsed.");
            }
            XMLObjectParser xMLObjectParser = this.parserStore.get(element.getTagName());
            boolean bl4 = bl3 = xMLObjectParser != null && xMLObjectParser.getReturnType().isAssignableFrom(xMLObject2.getNativeObject().getClass());
            if (!element.getTagName().equals(xMLObject2.getName()) && !bl3) {
                String string2 = "Element named " + element.getTagName() + " with idref=" + string + " does not match stored object with same id and tag name " + xMLObject2.getName();
                if (this.strictXML) {
                    throw new XMLParseException(string2);
                }
                if (this.parserWarnings) {
                    Logger.getLogger("dr.xml").warning(string2);
                }
            }
            if (this.verbose) {
                System.out.println("  Restoring idref=" + string);
            }
            return new Reference(xMLObject2);
        }
        int n3 = 1;
        if (element.getTagName().equals(CONCURRENT)) {
            if (this.concurrent) {
                throw new XMLParseException("Nested concurrent elements not allowed.");
            }
            this.concurrent = true;
            this.threads = new Vector();
        } else if (element.getTagName().equals("repeat")) {
            n3 = Integer.parseInt(element.getAttribute("count"));
        }
        XMLObject xMLObject3 = new XMLObject(element, xMLObject);
        XMLObjectParser xMLObjectParser = bl2 ? this.parserStore.get(xMLObject3.getName()) : null;
        String string = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < n3; ++i) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node object22 = nodeList.item(n);
                if (object22 instanceof Element) {
                    Object object2;
                    object = (Element)object22;
                    String string2 = object.getTagName();
                    if (this.verbose) {
                        System.out.println("Parsing " + string2);
                    }
                    boolean bl5 = xMLObjectParser == null || !xMLObjectParser.isAllowed(string2);
                    Object object3 = this.convert((Element)object, clazz, xMLObject3, bl, bl5);
                    xMLObject3.addChild(object3);
                    if (clazz == null || !(object3 instanceof XMLObject) || (object2 = ((XMLObject)object3).getNativeObject()) == null || !clazz.isInstance(object2)) continue;
                    return object2;
                }
                if (!(object22 instanceof Text) || ((String)(object = ((Text)object22).getData().trim())).length() <= 0) continue;
                xMLObject3.addChild(object);
            }
        }
        if (element.hasAttribute(ID)) {
            string = element.getAttribute(ID);
        }
        if (string != null && this.objectStore.get(string) != null) {
            throw new XMLParseException("Object with Id=" + string + " already exists");
        }
        Object object5 = null;
        if (xMLObjectParser != null) {
            object5 = xMLObjectParser.parseXMLObject(xMLObject3, string, this.objectStore, this.strictXML);
            if (object5 instanceof Identifiable) {
                ((Identifiable)object5).setId(string);
            }
            if (object5 instanceof Citable) {
                this.addCitable((Citable)object5);
            }
            if (object5 instanceof CompoundLikelihood) {
                Likelihood.FULL_LIKELIHOOD_SET.addAll(((CompoundLikelihood)object5).getLikelihoods());
            } else if (object5 instanceof Likelihood) {
                Likelihood.FULL_LIKELIHOOD_SET.add((Likelihood)object5);
            } else if (object5 instanceof Model) {
                Model.FULL_MODEL_SET.add((Model)object5);
            } else if (object5 instanceof Parameter) {
                Parameter.FULL_PARAMETER_SET.add((Parameter)object5);
            }
            xMLObject3.setNativeObject(object5);
        } else if (element.hasAttribute(ID)) {
            Logger.getLogger("dr.xml").warning("Element called, " + xMLObject3.getName() + ", has an ID, " + element.getAttribute(ID) + ", but no parser.");
        }
        if (string != null) {
            if (this.verbose) {
                System.out.println("  Storing " + xMLObject3.getName() + " with id=" + string);
            }
            this.objectStore.put(string, xMLObject3);
        }
        if (bl) {
            if (element.getTagName().equals(CONCURRENT)) {
                for (n = 0; n < xMLObject3.getChildCount(); ++n) {
                    Object object4 = xMLObject3.getChild(n);
                    if (!(object4 instanceof Runnable)) {
                        throw new XMLParseException("Concurrent element children must be runnable!");
                    }
                    object = new Thread((Runnable)object4);
                    ((Thread)object).start();
                    this.threads.add((Thread)object);
                }
                this.concurrent = false;
                for (Thread thread : this.threads) {
                    this.waitForThread(thread);
                }
            } else if (object5 instanceof Runnable && !this.concurrent) {
                this.executingRunnable();
                CitationLogHandler.closeHandler();
                if (object5 instanceof Spawnable && !((Spawnable)object5).getSpawnable()) {
                    ((Spawnable)object5).run();
                } else {
                    Thread thread = new Thread((Runnable)object5);
                    thread.start();
                    this.threads.add(thread);
                    this.waitForThread(thread);
                }
            }
            this.threads.removeAllElements();
        }
        return xMLObject3;
    }

    protected void executingRunnable() {
    }

    public Map<Pair<String, String>, List<Citation>> getCitationStore() {
        return this.citationStore;
    }

    public static FileReader getFileReader(XMLObject xMLObject, String string) throws XMLParseException {
        if (xMLObject.hasAttribute(string)) {
            File file = XMLParser.getFileHandle(xMLObject, string);
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("Input file " + file.getName() + " was not found in the working directory");
            }
        }
        throw new XMLParseException("Error reading input file in " + xMLObject.getId());
    }

    private static File getFileHandle(XMLObject xMLObject, String string) throws XMLParseException {
        String string2 = xMLObject.getStringAttribute(string);
        String string3 = System.getProperty("file.name.prefix");
        String string4 = System.getProperty("file.separator");
        if (string3 != null && (string3.trim().length() == 0 || string3.contains(string4))) {
            throw new XMLParseException("The specified file name prefix is illegal.");
        }
        String string5 = System.getProperty("mpi.rank.postfix");
        if (string5 != null) {
            if (string2.endsWith(".log")) {
                string2 = string2.substring(0, string2.length() - 4) + string5 + ".log";
            }
            if (string2.endsWith(".trees")) {
                string2 = string2.substring(0, string2.length() - 6) + string5 + ".trees";
            }
        }
        return FileHelpers.getFile(string2, string3);
    }

    public static PrintWriter getFilePrintWriter(XMLObject xMLObject, String string) throws XMLParseException {
        return XMLParser.getFilePrintWriter(xMLObject, string, "fileName");
    }

    public static PrintWriter getFilePrintWriter(XMLObject xMLObject, String string, String string2) throws XMLParseException {
        if (xMLObject.hasAttribute(string2)) {
            File file = XMLParser.getLogFile(xMLObject, string2);
            try {
                return new PrintWriter(new FileOutputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + file.getAbsolutePath() + "' can not be opened for " + string + " element.");
            }
        }
        return new PrintWriter(System.out);
    }

    public static File getLogFile(XMLObject xMLObject, String string) throws XMLParseException {
        File file = XMLParser.getFileHandle(xMLObject, string);
        boolean bl = false;
        if (xMLObject.hasAttribute("overwrite")) {
            bl = xMLObject.getBooleanAttribute("overwrite");
        }
        if (System.getProperty("log.allow.overwrite") != null) {
            bl = Boolean.parseBoolean(System.getProperty("log.allow.overwrite", "false"));
        }
        if (file.exists() && !bl) {
            throw new XMLParseException("\nThe log file " + file.getName() + " already exists in the working directory.\nTo allow it to be overwritten, use the '-overwrite' command line option when running\nBEAST or select the option in the Run Options dialog box as appropriate.");
        }
        return file;
    }

    public Map<String, XMLObject> getObjectStore() {
        return this.objectStore;
    }

    private void waitForThread(Thread thread) {
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addCitable(Citable citable) {
        LinkedList<Citation> linkedList = new LinkedList<Citation>();
        for (Citation citation : citable.getCitations()) {
            if (citation.getStatus() == Citation.Status.IN_PREPARATION) continue;
            linkedList.add(citation);
        }
        if (linkedList.size() > 0) {
            Pair<String, String> pair = new Pair<String, String>(citable.getCategory().toString(), citable.getDescription());
            this.citationStore.put(pair, linkedList);
        }
    }

    class ParserComparator
    implements Comparator<String> {
        ParserComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            String string3 = string.toUpperCase();
            String string4 = string2.toUpperCase();
            return string3.compareTo(string4);
        }
    }

    public class ArrayParser
    extends AbstractXMLObjectParser {
        @Override
        public String getParserName() {
            return "array";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                arrayList.add(xMLObject.getChild(i));
            }
            return arrayList;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an array of the objects it contains.";
        }

        @Override
        public Class getReturnType() {
            return Object[].class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Object.class, "Objects to be put in an array", 1, Integer.MAX_VALUE)};
        }
    }

    private class MyErrorHandler
    extends DefaultHandler {
        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.out.println("Warning: ");
            this.printInfo(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            System.out.println("Error: ");
            this.printInfo(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.out.println("Fatal error: ");
            this.printInfo(sAXParseException);
        }

        private void printInfo(SAXParseException sAXParseException) {
            System.out.println("\tLine number: " + sAXParseException.getLineNumber());
            System.out.println("\tColumn number: " + sAXParseException.getColumnNumber());
            System.out.println("\tError message: " + sAXParseException.getMessage());
        }
    }

    public static class Utils {
        public static void validateTagName(Element element, String string) throws XMLParseException {
            if (!element.getTagName().equals(string)) {
                throw new XMLParseException("Wrong tag name! Expected " + string + ", found " + element.getTagName() + ".");
            }
        }

        public static boolean hasAttribute(Element element, String string) {
            String string2 = element.getAttribute(string);
            return string2 != null && !string2.equals("");
        }

        public static Element getFirstByName(Element element, String string) {
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() > 0) {
                return (Element)nodeList.item(0);
            }
            return null;
        }
    }
}

