/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.util.HeapSort;
import dr.xml.XMLModelIdentifiable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XMLModelFile
implements ListModel {
    private final Element xmlModel;
    private final Map<String, XMLModelIdentifiable> identifiedElements;

    public XMLModelFile(Element element) {
        Cloneable cloneable;
        Object object;
        this.xmlModel = element;
        this.identifiedElements = new HashMap<String, XMLModelIdentifiable>();
        Iterator iterator = this.xmlModel.getDescendants(new IdentifiedFilter());
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            cloneable = ((Element)object).getAttribute("id");
            if (cloneable != null) {
                this.identifiedElements.put(((Attribute)cloneable).getValue(), new XMLModelIdentifiable(((Attribute)cloneable).getValue(), (Element)object));
                continue;
            }
            cloneable = ((Element)object).getAttribute("idref");
            this.identifiedElements.get(((Attribute)cloneable).getValue()).addReference((Element)object);
        }
        object = this.xmlModel.getDescendants(new MCMCFilter());
        cloneable = (Element)object.next();
        if (cloneable == null) {
            System.err.println("Error: cannot find mcmc element");
        } else {
            for (Object e : ((Element)cloneable).getChildren("posterior")) {
                if (!(e instanceof Element)) continue;
                Element element2 = (Element)e;
            }
            ((Content)cloneable).detach();
        }
    }

    public Set<String> getIdentifiedElementNames() {
        return this.identifiedElements.keySet();
    }

    public void prefixIdentifiedNames(String string, Map<String, String> map, boolean bl) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (Map.Entry<String, XMLModelIdentifiable> entry : this.identifiedElements.entrySet()) {
            String string2;
            if (map.containsKey(entry.getKey())) {
                string2 = map.get(entry.getKey());
                if (bl) {
                    entry.getValue().restoreDefinition();
                } else {
                    entry.getValue().removeDefinition();
                }
            } else {
                string2 = string + entry.getKey();
            }
            entry.getValue().rename(string2);
        }
    }

    public void printIdentified() {
        System.out.println("Identified elements follow");
        XMLOutputter xMLOutputter = new XMLOutputter();
        for (Map.Entry<String, XMLModelIdentifiable> entry : this.identifiedElements.entrySet()) {
            System.out.println("Original name: " + entry.getKey());
            entry.getValue().print(xMLOutputter, System.out);
        }
    }

    public void print(XMLOutputter xMLOutputter, OutputStream outputStream) {
        try {
            xMLOutputter.output(this.xmlModel.getContent(), outputStream);
        }
        catch (IOException iOException) {
            System.err.println("Error writing model!");
        }
    }

    @Override
    public int getSize() {
        return this.identifiedElements.size();
    }

    public Object getElementAt(int n) {
        if (n < this.identifiedElements.size()) {
            Object[] objectArray = this.identifiedElements.keySet().toArray();
            HeapSort.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return object.toString().compareTo(object2.toString());
                }
            });
            return objectArray[n];
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }

    public static void main(String[] stringArray) {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(new File("testSimplePathSampling.xml"));
            XMLModelFile xMLModelFile = new XMLModelFile(document.getRootElement());
            xMLModelFile.printIdentified();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("samplingMean", "samplingMean");
            xMLModelFile.prefixIdentifiedNames("model1.", hashMap, false);
            xMLModelFile.printIdentified();
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
    }

    public class IdentifiedFilter
    implements Filter {
        @Override
        public boolean matches(Object object) {
            if (!(object instanceof Element)) {
                return false;
            }
            return ((Element)object).getAttribute("id") != null || ((Element)object).getAttribute("idref") != null;
        }
    }

    public class MCMCFilter
    implements Filter {
        @Override
        public boolean matches(Object object) {
            return object instanceof Element && ((Element)object).getName().equals("mcmc");
        }
    }
}

