/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.AttributeRule;
import dr.xml.XMLDocumentationHandler;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class StringAttributeRule
extends AttributeRule {
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private List<String> validValues = null;
    private String example = null;

    public StringAttributeRule(String string, String string2) {
        this(string, string2, (String)null, false);
    }

    public StringAttributeRule(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public StringAttributeRule(String string, String string2, boolean bl) {
        this(string, string2, null, bl, 0, Integer.MAX_VALUE);
    }

    public StringAttributeRule(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, 0, Integer.MAX_VALUE);
    }

    public StringAttributeRule(String string, String string2, String[] stringArray, boolean bl) {
        this(string, string2, null, bl, 0, Integer.MAX_VALUE);
        this.validValues = new ArrayList<String>();
        for (String string3 : stringArray) {
            this.validValues.add(string3);
        }
        this.example = null;
    }

    public StringAttributeRule(String string, String string2, Enum[] enumArray, boolean bl) {
        this(string, string2, null, bl, 0, Integer.MAX_VALUE);
        this.validValues = new ArrayList<String>();
        for (Enum enum_ : enumArray) {
            this.validValues.add(enum_.name());
        }
        this.example = null;
    }

    public StringAttributeRule(String string, String string2, String[][] stringArray, boolean bl) {
        this(string, string2, null, bl, 0, Integer.MAX_VALUE);
        this.validValues = new ArrayList<String>();
        String[][] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3;
            for (String string3 : stringArray3 = stringArray2[i]) {
                this.validValues.add(string3);
            }
        }
        this.example = null;
    }

    private StringAttributeRule(String string, String string2, String string3, boolean bl, int n, int n2) {
        this.setName(string);
        this.setAttributeClass(String.class);
        this.setOptional(bl);
        this.setDescription(string2);
        this.example = string3;
        this.minLength = n;
        this.maxLength = n2;
    }

    @Override
    public boolean isSatisfied(XMLObject xMLObject) {
        if (super.isSatisfied(xMLObject)) {
            if (!this.getOptional()) {
                try {
                    String string = (String)this.getAttribute(xMLObject);
                    if (this.validValues != null) {
                        for (String string2 : this.validValues) {
                            if (!string.equals(string2)) continue;
                            return true;
                        }
                        return false;
                    }
                    return string.length() >= this.minLength || string.length() <= this.maxLength;
                }
                catch (XMLParseException xMLParseException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String ruleString() {
        StringBuffer stringBuffer = new StringBuffer(super.ruleString());
        if (this.validValues != null && this.validValues.size() > 0) {
            stringBuffer.append(" from {");
            stringBuffer.append(this.validValues.get(0));
            for (int i = 1; i < this.validValues.size(); ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.validValues.get(i));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String htmlRuleString(XMLDocumentationHandler xMLDocumentationHandler) {
        String string = "<div class=\"" + (this.getOptional() ? "optional" : "required") + "rule\"> Attribute  <span class=\"attrname\">" + this.getName() + "</span>";
        if (this.validValues != null) {
            string = string + " &isin; {<tt>" + this.validValues.get(0) + "</tt>";
            for (int i = 1; i < this.validValues.size(); ++i) {
                string = string + ", <tt>" + this.validValues.get(i) + "</tt>";
            }
            string = string + "}";
        } else {
            string = string + " is string";
        }
        string = string + " <div class=\"description\">" + this.getDescription() + "</div>";
        string = string + "</div>";
        return string;
    }

    @Override
    public String getExample() {
        Random random = new Random();
        if (this.validValues != null) {
            return this.validValues.get(random.nextInt(this.validValues.size()));
        }
        return this.example;
    }

    @Override
    public boolean hasExample() {
        return this.validValues != null || this.example != null;
    }
}

