/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PositiveOrderedTransform
extends Transform.MultivariateTransform {
    public static final String NAME = "positiveOrderedTransform";
    public static final String DIMENSION = "dim";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("dim", false)};

        @Override
        public String getParserName() {
            return PositiveOrderedTransform.NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute(PositiveOrderedTransform.DIMENSION);
            return new PositiveOrderedTransform(n);
        }

        @Override
        public String getParserDescription() {
            return "A compound matrix parametrized by its eigen values and vectors.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return Transform.MultivariateTransform.class;
        }
    };

    public PositiveOrderedTransform(int n) {
        super(n);
    }

    @Override
    protected double[] transform(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        dArray2[0] = Math.log(dArray[0]);
        for (int i = 1; i < this.dim; ++i) {
            dArray2[i] = Math.log(dArray[i] - dArray[i - 1]);
        }
        return dArray2;
    }

    @Override
    public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected double[] inverse(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        dArray2[0] = Math.exp(dArray[0]);
        for (int i = 1; i < this.dim; ++i) {
            dArray2[i] = dArray2[i - 1] + Math.exp(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not relevant.");
    }

    @Override
    public boolean isInInteriorDomain(double[] dArray) {
        if (dArray[0] <= 0.0) {
            return false;
        }
        for (int i = 1; i < this.dim; ++i) {
            if (!(dArray[i] - dArray[i - 1] <= 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTransformName() {
        return "PositiveOrdered";
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        double d = Math.log(dArray[0]);
        for (int i = 1; i < this.dim; ++i) {
            d += Math.log(dArray[i] - dArray[i - 1]);
        }
        return -d;
    }

    @Override
    public double[] getGradientLogJacobianInverse(double[] dArray) {
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray2[i] = 1.0;
        }
        return dArray2;
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = i; j < this.dim; ++j) {
                dArray2[j][i] = Math.exp(dArray[j]);
            }
        }
        return dArray2;
    }
}

