/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.OutputStream;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class MessageLogHandler
extends StreamHandler {
    public MessageLogHandler() {
        this(System.out);
        this.setFormatter(new MessageLogFormatter());
    }

    public MessageLogHandler(OutputStream outputStream) {
        this.setOutputStream(outputStream);
        this.setFormatter(new MessageLogFormatter());
    }

    @Override
    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }

    private class MessageLogFormatter
    extends Formatter {
        private final String lineSeparator = System.getProperty("line.separator");

        private MessageLogFormatter() {
        }

        @Override
        public synchronized String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatMessage(logRecord));
            stringBuffer.append(this.lineSeparator);
            return stringBuffer.toString();
        }
    }
}

