/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.inference.model.MatrixParameterInterface;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class MatrixInnerProductTransform
extends Transform.MatrixVariateTransform {
    private static final String MATRIX_INNER_PRODUCT = "matrixInnerProductTransform";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String N_ROWS = "nRows";
        private static final String N_COLS = "nColumns";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n;
            int n2;
            if (xMLObject.getChildCount() > 0) {
                MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
                n2 = matrixParameterInterface.getRowDimension();
                n = matrixParameterInterface.getColumnDimension();
            } else {
                n2 = xMLObject.getIntegerAttribute(N_ROWS);
                n = xMLObject.getIntegerAttribute(N_COLS);
            }
            return new MatrixInnerProductTransform(n2, n);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[0];
        }

        @Override
        public String getParserDescription() {
            return "Takes the matrix X and transforms it to XXt";
        }

        @Override
        public Class getReturnType() {
            return MatrixInnerProductTransform.class;
        }

        @Override
        public String getParserName() {
            return MatrixInnerProductTransform.MATRIX_INNER_PRODUCT;
        }
    };

    public MatrixInnerProductTransform(int n, int n2) {
        super(n * n2, n, n2);
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException(this.getTransformName() + " is not invertible");
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public String getTransformName() {
        return MATRIX_INNER_PRODUCT;
    }

    @Override
    protected double[] transform(double[] dArray) {
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.rowDimension, this.columnDimension, dArray);
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.rowDimension, this.rowDimension);
        CommonOps.multTransB(denseMatrix64F, denseMatrix64F, denseMatrix64F2);
        return denseMatrix64F2.getData();
    }

    @Override
    protected double[] inverse(double[] dArray) {
        throw new RuntimeException(this.getTransformName() + " is not invertible");
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        throw new RuntimeException(this.getTransformName() + " is not invertible");
    }

    @Override
    protected double[] getGradientLogJacobianInverse(double[] dArray) {
        throw new RuntimeException(this.getTransformName() + " is not invertible");
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        throw new RuntimeException(this.getTransformName() + " is not invertible");
    }

    @Override
    protected boolean isInInteriorDomain(double[] dArray) {
        return dArray.length == this.dim;
    }
}

