/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.SubstitutionModel;
import dr.oldevomodel.treelikelihood.AbstractLikelihoodCore;
import dr.oldevomodel.treelikelihood.TreeLikelihood;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

@Deprecated
public class NodePosteriorTreeLikelihood
extends TreeLikelihood
implements TreeTraitProvider {
    protected double[][] nodePosteriors;
    protected double[][] forwardProbs;
    protected double[] likes;
    boolean posteriorsKnown;
    private double[] childPartials;
    private double[] partialLikelihood;
    TreeTrait posteriors = new TreeTrait.DA(){

        @Override
        public String getTraitName() {
            return "posteriors";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.NODE;
        }

        @Override
        public double[] getTrait(Tree tree, NodeRef nodeRef) {
            if (tree != NodePosteriorTreeLikelihood.this.treeModel) {
                throw new RuntimeException("Can only calculate node posteriors on treeModel given to constructor");
            }
            if (!NodePosteriorTreeLikelihood.this.posteriorsKnown) {
                NodePosteriorTreeLikelihood.this.calculatePosteriors();
            }
            return NodePosteriorTreeLikelihood.this.nodePosteriors[nodeRef.getNumber()];
        }
    };
    public static final String NODE_POSTERIOR_LIKELIHOOD = "nodePosteriorLikelihood";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("useAmbiguities", true), AttributeRule.newBooleanRule("allowMissingTaxa", true), new ElementRule(PatternList.class), new ElementRule(TreeModel.class), new ElementRule(SiteModel.class), new ElementRule(BranchRateModel.class, true), new ElementRule(SubstitutionModel.class)};

        @Override
        public String getParserName() {
            return NodePosteriorTreeLikelihood.NODE_POSTERIOR_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getAttribute("useAmbiguities", false);
            boolean bl2 = xMLObject.getAttribute("storePartials", true);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            SiteModel siteModel = (SiteModel)xMLObject.getChild(SiteModel.class);
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            return new NodePosteriorTreeLikelihood(patternList, treeModel, siteModel, branchRateModel, null, bl, false, bl2, false);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of a patternlist on a tree given the site model.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public NodePosteriorTreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(patternList, treeModel, siteModel, branchRateModel, tipStatesModel, bl, bl2, bl3, bl4, false);
        int n = treeModel.getExternalNodeCount();
        for (int i = 0; i < n; ++i) {
            String string = treeModel.getTaxonId(i);
            int n2 = patternList.getTaxonIndex(string);
            this.setPartials(this.likelihoodCore, patternList, this.categoryCount, n2, i);
        }
        this.childPartials = new double[this.stateCount * this.patternCount];
        this.partialLikelihood = new double[this.stateCount * this.patternCount];
        this.posteriorsKnown = false;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return new TreeTrait[]{this.posteriors};
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.posteriors;
    }

    public double[] getPosteriors(int n) {
        if (!this.posteriorsKnown) {
            this.calculatePosteriors();
        }
        return this.nodePosteriors[n];
    }

    public void getNodeMatrix(int n, double[] dArray) {
        ((AbstractLikelihoodCore)this.likelihoodCore).getNodeMatrix(n, 0, dArray);
    }

    public void calculatePosteriors() {
        int n = this.treeModel.getNodeCount();
        this.traverseForward(this.treeModel, this.treeModel.getRoot());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    double[] dArray = this.nodePosteriors[i];
                    int n2 = this.stateCount * j + k;
                    dArray[n2] = dArray[n2] / this.likes[j];
                }
            }
        }
        this.posteriorsKnown = true;
    }

    @Override
    protected double calculateLogLikelihood() {
        this.posteriorsKnown = false;
        return super.calculateLogLikelihood();
    }

    public void traverseForward(TreeModel treeModel, NodeRef nodeRef) {
        int n;
        Object object;
        if (this.nodePosteriors == null) {
            this.nodePosteriors = new double[treeModel.getNodeCount()][this.patternCount * this.stateCount];
        }
        if (this.forwardProbs == null) {
            this.forwardProbs = new double[treeModel.getNodeCount()][this.patternCount * this.stateCount];
        }
        int n2 = nodeRef.getNumber();
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        if (nodeRef2 == null) {
            double[] dArray = this.frequencyModel.getFrequencies();
            object = this.getRootPartials();
            if (this.likes == null) {
                this.likes = new double[this.patternCount];
            }
            for (n = 0; n < this.patternCount; ++n) {
                System.arraycopy(dArray, 0, this.forwardProbs[n2], n * this.stateCount, this.stateCount);
                this.likes[n] = 0.0;
                for (int i = 0; i < this.stateCount; ++i) {
                    this.nodePosteriors[n2][this.stateCount * n + i] = this.forwardProbs[n2][this.stateCount * n + i] * object[n * this.stateCount + i];
                    this.likes[n] = this.likes[n] + object[this.stateCount * n + i] * dArray[i];
                }
            }
        } else {
            int n3 = nodeRef2.getNumber();
            int n4 = treeModel.getChildCount(nodeRef2);
            System.arraycopy(this.forwardProbs[n3], 0, this.forwardProbs[n2], 0, this.stateCount * this.patternCount);
            for (n = 0; n < n4; ++n) {
                NodeRef nodeRef3 = treeModel.getChild(nodeRef2, n);
                int n5 = nodeRef3.getNumber();
                if (n5 == n2) continue;
                this.getNodeMatrix(n5, this.probabilities);
                this.likelihoodCore.getPartials(n5, this.childPartials);
                this.accumulateMatrixMultiply(this.probabilities, this.childPartials, this.forwardProbs[n2]);
            }
            this.getNodeMatrix(n2, this.probabilities);
            this.likelihoodCore.getPartials(n2, this.partialLikelihood);
            this.matrixMultiplyBackward(this.probabilities, this.forwardProbs[n2], this.nodePosteriors[n2]);
            for (n = 0; n < this.patternCount * this.stateCount; ++n) {
                this.forwardProbs[n2][n] = this.nodePosteriors[n2][n];
                this.nodePosteriors[n2][n] = this.nodePosteriors[n2][n] * this.partialLikelihood[n];
            }
        }
        if (!treeModel.isExternal(nodeRef)) {
            for (int i = 0; i < treeModel.getChildCount(nodeRef); ++i) {
                object = treeModel.getChild(nodeRef, i);
                this.traverseForward(treeModel, (NodeRef)object);
            }
        }
    }

    public void accumulateMatrixMultiply(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.stateCount; ++j) {
                double d = 0.0;
                for (int k = 0; k < this.stateCount; ++k) {
                    d += dArray[n3] * dArray2[n2 + k];
                    ++n3;
                }
                dArray3[n] = d * dArray3[n];
                ++n;
            }
            n2 += this.stateCount;
        }
    }

    public void matrixMultiplyBackward(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                int n3 = j;
                double d = 0.0;
                for (int k = 0; k < this.stateCount; ++k) {
                    d += dArray[n3] * dArray2[n2 + k];
                    n3 += this.stateCount;
                }
                dArray3[n] = d;
                ++n;
            }
            n2 += this.stateCount;
        }
    }
}

