/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.approxPopTree;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PopTreeModel
extends FlexibleTree {
    protected Map<NodeRef, LinkedList<NodeRef>> populations;
    protected double time;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), AttributeRule.newDoubleRule("populationNodeHeight", false)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            double d = xMLObject.getDoubleAttribute(PopTreeModel.POP_HEIGHT_CUTOFF);
            PopTreeModel popTreeModel = null;
            try {
                popTreeModel = new PopTreeModel(treeModel, d);
            }
            catch (MutableTree.InvalidTreeException invalidTreeException) {
                invalidTreeException.printStackTrace();
            }
            return popTreeModel;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Creates a Population Tree Model with specified divergence cut-off for population nodes";
        }

        @Override
        public Class getReturnType() {
            return PopTreeModel.class;
        }

        @Override
        public String getParserName() {
            return PopTreeModel.POP_TREE_MODEL;
        }
    };
    public static final String POP_TREE_MODEL = "popTreeModel";
    public static final String POP_HEIGHT_CUTOFF = "populationNodeHeight";
    public static final String TREE_MODEL = "treeModel";

    public PopTreeModel(TreeModel treeModel, double d) throws MutableTree.InvalidTreeException {
        super(treeModel);
        this.time = d;
        this.populations = new HashMap<NodeRef, LinkedList<NodeRef>>();
        this.enforcePopulations(d);
    }

    public void enforcePopulations(double d) {
        this.enforcePopulations(d, this.getRoot());
    }

    public void enforcePopulations(double d, NodeRef nodeRef) {
        this.beginTreeEdit();
        this.reducePopulations(d, nodeRef);
        this.endTreeEdit();
        this.adoptTreeModelOrdering();
    }

    protected void reducePopulations(double d, NodeRef nodeRef) {
        if (this.getNodeHeight(nodeRef) <= d) {
            if (!this.isExternal(nodeRef)) {
                this.setNodeHeight(nodeRef, d);
            }
            this.mergeSubtreePopulation(nodeRef);
        } else {
            for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = this.getChild(nodeRef, i);
                this.reducePopulations(d, nodeRef2);
            }
        }
    }

    public void splitPopulation(NodeRef nodeRef) {
        this.splitPopulation(nodeRef, 0.5);
    }

    public void splitPopulation(NodeRef nodeRef, double d) {
        if (!this.populations.containsKey(nodeRef) || this.populations.get(nodeRef).size() >= 1) {
            // empty if block
        }
    }

    public void mergePopulations(NodeRef nodeRef) {
        this.setNodeHeight(nodeRef, this.time);
        this.enforcePopulations(this.time, nodeRef);
    }

    protected void mergeSubtreePopulation(NodeRef nodeRef) {
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        if (this.getNodeTaxon(nodeRef) == null) {
            this.setNodeTaxon(nodeRef, new Taxon("popNode" + this.populations.size()));
        }
        if (this.isExternal(nodeRef)) {
            // empty if block
        }
        linkedList.addFirst(nodeRef);
        block0: while (true) {
            NodeRef nodeRef2;
            if (this.isExternal(nodeRef2 = (NodeRef)linkedList.removeFirst())) {
                linkedList.addFirst(nodeRef2);
                this.populations.put(nodeRef, linkedList);
                return;
            }
            int n = this.getChildCount(nodeRef2);
            int n2 = 0;
            while (true) {
                if (this.getChildCount(nodeRef2) <= 0) continue block0;
                NodeRef nodeRef3 = this.getChild(nodeRef2, n2);
                linkedList.addFirst(nodeRef3);
                this.removeChild(nodeRef2, nodeRef3);
            }
            break;
        }
    }

    public int getPopulationNodeCount() {
        return this.populations.size();
    }

    @Override
    public String toString() {
        return super.toString() + this.formatPopulationNodes();
    }

    public String formatPopulationNodes() {
        String string = "\n";
        string = string + this.getExternalNodeCount() + "\n";
        for (NodeRef nodeRef : this.populations.keySet()) {
            string = string + this.getNodeTaxon(nodeRef).getId() + "(" + this.isExternal(nodeRef) + ")::";
            for (NodeRef nodeRef2 : this.populations.get(nodeRef)) {
                string = string + this.getNodeTaxon(nodeRef2).getId() + ",";
            }
            string = string + "\n";
        }
        return string;
    }
}

