/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class ParetoDistribution
implements Distribution {
    private double scale;
    private double shape;

    public ParetoDistribution(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new RuntimeException("Shape and scale must be positive.");
        }
        this.scale = d;
        this.shape = d2;
    }

    @Override
    public double pdf(double d) {
        return d > this.scale ? this.shape * Math.pow(this.scale, this.shape) / Math.pow(d, this.shape + 1.0) : 0.0;
    }

    @Override
    public double logPdf(double d) {
        if (d < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.shape) + this.shape * Math.log(this.scale) - (this.shape + 1.0) * Math.log(d);
    }

    @Override
    public double cdf(double d) {
        if (d < this.scale) {
            return 0.0;
        }
        return 1.0 - Math.pow(this.scale / d, this.shape);
    }

    @Override
    public double quantile(double d) {
        return 1.0 / Math.pow(1.0 - d, 1.0 / this.shape);
    }

    @Override
    public double mean() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * this.shape / (this.shape - 1.0);
    }

    @Override
    public double variance() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * this.scale * this.shape / (this.shape - 1.0) * (this.shape - 1.0) * (this.shape - 2.0);
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return null;
    }
}

