/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.ErrorFunction;
import dr.math.GammaFunction;
import dr.math.UnivariateFunction;
import dr.math.UnivariateMinimum;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Beta;

public class NegativeBinomialDistribution
implements Distribution {
    double mean;
    double alpha;

    public NegativeBinomialDistribution(double d, double d2) {
        this.mean = d;
        this.alpha = d2;
    }

    @Override
    public double pdf(double d) {
        return NegativeBinomialDistribution.pdf(d, this.mean, this.alpha);
    }

    @Override
    public double logPdf(double d) {
        return NegativeBinomialDistribution.logPdf(d, this.mean, this.alpha);
    }

    @Override
    public double cdf(double d) {
        return NegativeBinomialDistribution.cdf(d, this.mean, this.alpha);
    }

    @Override
    public double quantile(double d) {
        double d2 = Math.sqrt(this.mean + this.mean * this.mean * this.alpha);
        final double d3 = -1.0 * (this.mean * this.mean) / (this.mean - d2 * d2);
        final double d4 = this.mean / (d2 * d2);
        final double d5 = d;
        double d6 = 1.0 / d4;
        double d7 = (1.0 - d4) * d6;
        double d8 = (d6 + d7) / d2;
        double d9 = Math.sqrt(2.0) * ErrorFunction.inverseErf(2.0 * d - 1.0);
        final double d10 = this.mean + d2 * (d9 + d8 * (d9 * d9 - 1.0) / 6.0);
        UnivariateFunction univariateFunction = new UnivariateFunction(){
            double tent = Double.NaN;

            @Override
            public double evaluate(double d) {
                try {
                    this.tent = Beta.regularizedBeta(d4, d3, d + 1.0);
                }
                catch (MathException mathException) {
                    return Double.NaN;
                }
                double d2 = Math.abs(this.tent - d5);
                return d2;
            }

            public int getNumArguments() {
                return 1;
            }

            @Override
            public double getLowerBound() {
                return Math.min(d10 - 0.2 * d10, 0.0);
            }

            @Override
            public double getUpperBound() {
                return d10 + 0.2 * d10;
            }
        };
        UnivariateMinimum univariateMinimum = new UnivariateMinimum();
        double d11 = univariateMinimum.findMinimum(univariateFunction);
        return Math.ceil(d11);
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.mean + this.mean * this.mean * this.alpha;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException();
    }

    public static double pdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.exp(NegativeBinomialDistribution.logPdf(d, d2, d3));
    }

    public static double logPdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d4 = 1.0 / d3;
        double d5 = d4 / (d4 + d2);
        return Math.log(1.0 - d5) * d + Math.log(d5) * d4 + GammaFunction.lnGamma(d4 + d) - GammaFunction.lnGamma(d4) - GammaFunction.lnGamma(d + 1.0);
    }

    public static double cdf(double d, double d2, double d3) {
        double d4 = 1.0 / d3;
        double d5 = d4 / (d4 + d2);
        try {
            return Beta.regularizedBeta(d5, d4, d + 1.0);
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Test negative binomial");
        double d = 5.0;
        double d2 = 5.0;
        double d3 = (d2 * d2 - d) / (d * d);
        NegativeBinomialDistribution negativeBinomialDistribution = new NegativeBinomialDistribution(5.0, d3);
        System.out.println("Mean 5, sd 5, x 5, pdf 0.074487, logPdf -2.59713, median 4");
        System.out.println("pdf = " + negativeBinomialDistribution.pdf(5.0));
        System.out.println("quantile(0.5) aka median = " + negativeBinomialDistribution.quantile(0.5));
        System.out.println("logPdf = " + negativeBinomialDistribution.logPdf(5.0));
    }
}

