/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.ChiSquareDistribution;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.NormalDistribution;
import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.BisectionZeroFinder;
import dr.math.iterations.NewtonZeroFinder;

public class InverseGaussianDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return InverseGaussianDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double m;
    protected double sd;
    protected double shape;

    public InverseGaussianDistribution(double d, double d2) {
        this.m = d;
        this.shape = d2;
        this.sd = InverseGaussianDistribution.calculateSD(d, d2);
    }

    public double getMean() {
        return this.m;
    }

    public void setMean(double d) {
        this.m = d;
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double d) {
        this.shape = d;
        this.sd = InverseGaussianDistribution.calculateSD(this.m, this.shape);
    }

    public static double calculateSD(double d, double d2) {
        return Math.sqrt(d * d * d / d2);
    }

    @Override
    public double pdf(double d) {
        return InverseGaussianDistribution.pdf(d, this.m, this.shape);
    }

    @Override
    public double logPdf(double d) {
        return InverseGaussianDistribution.logPdf(d, this.m, this.shape);
    }

    @Override
    public double cdf(double d) {
        return InverseGaussianDistribution.cdf(d, this.m, this.shape);
    }

    @Override
    public double quantile(double d) {
        return InverseGaussianDistribution.quantile(d, this.m, this.shape);
    }

    @Override
    public double mean() {
        return InverseGaussianDistribution.mean(this.m, this.shape);
    }

    @Override
    public double variance() {
        return InverseGaussianDistribution.variance(this.m, this.shape);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3) {
        double d4 = Math.sqrt(d3 / (Math.PI * 2 * d * d * d));
        double d5 = -d3 * (d - d2) * (d - d2) / (2.0 * d2 * d2 * d);
        return d4 * Math.exp(d5);
    }

    public static double logPdf(double d, double d2, double d3) {
        double d4 = Math.sqrt(d3 / (Math.PI * 2 * d * d * d));
        double d5 = -d3 * (d - d2) * (d - d2) / (2.0 * d2 * d2 * d);
        return Math.log(d4) + d5;
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0 || d2 <= 0.0 || d3 <= 0.0) {
            return Double.NaN;
        }
        double d4 = Math.sqrt(d3 / d);
        double d5 = d / d2;
        double d6 = NormalDistribution.cdf(d4 * (d5 - 1.0), 0.0, 1.0, false);
        double d7 = NormalDistribution.cdf(-d4 * (d5 + 1.0), 0.0, 1.0, false);
        if (d7 == 0.0) {
            return d6;
        }
        double d8 = 2.0 * d3 / d2;
        if (d8 >= Double.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        return d6 + Math.exp(d8) * d7;
    }

    public static double quantile(double d, double d2, double d3) {
        double d4;
        if (d < 0.01 || d > 0.99) {
            System.err.print("Quantile is " + d);
            throw new RuntimeException("Quantile is too low/high to calculate (numerical estimation for extreme values is incomplete)");
        }
        if (d3 / d2 > 2.0) {
            d4 = (NormalDistribution.quantile(d, 0.0, 1.0) - 0.5 * Math.sqrt(d2 / d3)) / Math.sqrt(d3 / d2);
            d4 = d2 * Math.exp(d4);
        } else {
            d4 = d3 / (GammaDistribution.quantile(1.0 - d, 0.5, 1.0) * 2.0);
            if (d4 > d2 / 2.0) {
                d4 = d2 * Math.exp(GammaDistribution.quantile(d, 0.5, 1.0) * 0.1);
            }
        }
        final InverseGaussianDistribution inverseGaussianDistribution = new InverseGaussianDistribution(d2, d3);
        final double d5 = d;
        NewtonZeroFinder newtonZeroFinder = new NewtonZeroFinder(new OneVariableFunction(){

            @Override
            public double value(double d) {
                return inverseGaussianDistribution.cdf(d) - d5;
            }
        }, d4);
        newtonZeroFinder.evaluate();
        if (Double.isNaN(newtonZeroFinder.getResult()) || newtonZeroFinder.getPrecision() > 5.0E-6) {
            newtonZeroFinder = new NewtonZeroFinder(new OneVariableFunction(){

                @Override
                public double value(double d) {
                    return inverseGaussianDistribution.cdf(d) - d5;
                }
            }, d4);
            newtonZeroFinder.initializeIterations();
            double d6 = 0.0;
            double d7 = Double.NaN;
            double d8 = 10000.0;
            double d9 = 1.0E-5;
            for (int i = 0; i < 50; ++i) {
                newtonZeroFinder.evaluateIteration();
                double d10 = inverseGaussianDistribution.cdf(newtonZeroFinder.getResult()) - d;
                if (d6 > 0.0 && d10 < 0.0 || d6 < 0.0 && d10 > 0.0) {
                    d8 = Math.max(d7, newtonZeroFinder.getResult());
                    d9 = Math.min(d7, newtonZeroFinder.getResult());
                    d8 = Math.min(10000.0, d8);
                    break;
                }
                d6 = d10;
                d7 = newtonZeroFinder.getResult();
            }
            return InverseGaussianDistribution.calculateZeroFinderApproximation(d, d2, d3, d9, d8, d4);
        }
        return newtonZeroFinder.getResult();
    }

    private static double calculateZeroFinderApproximation(double d, double d2, double d3, double d4, double d5, double d6) {
        final InverseGaussianDistribution inverseGaussianDistribution = new InverseGaussianDistribution(d2, d3);
        final double d7 = d;
        BisectionZeroFinder bisectionZeroFinder = new BisectionZeroFinder(new OneVariableFunction(){

            @Override
            public double value(double d) {
                return inverseGaussianDistribution.cdf(d) - d7;
            }
        }, d4, d5);
        bisectionZeroFinder.setInitialValue(d6);
        bisectionZeroFinder.initializeIterations();
        double d8 = Double.NaN;
        double d9 = 10.0;
        double d10 = 10.0;
        double d11 = 10.0;
        int n = 0;
        while (d10 > 0.001 && n < 10) {
            bisectionZeroFinder.evaluateIteration();
            d10 = Math.abs(inverseGaussianDistribution.cdf(bisectionZeroFinder.getResult()) - d);
            if (d10 < d9) {
                d9 = d10;
                d8 = bisectionZeroFinder.getResult();
            } else if (d11 == d10) {
                ++n;
            }
            d11 = d10;
        }
        bisectionZeroFinder.finalizeIterations();
        return d8;
    }

    private static double calculateShiftedGammaApproximation(double d, double d2, double d3) {
        double d4 = 3.0 * d2 * d2 / (4.0 * d3);
        double d5 = d2 / 3.0;
        double d6 = 8.0 * d3 / (9.0 * d2);
        return d4 * ChiSquareDistribution.quantile(d, d6) + d5;
    }

    private static double calculateShiftedGammaApproximationWithRIG(double d, double d2, double d3) {
        double d4 = (3.0 * d3 + 8.0 * d2) / (4.0 * d3 * (d3 + 2.0 * d2));
        double d5 = (d3 + 3.0 * d2) / (d2 * (3.0 * d3 + 8.0 * d2));
        double d6 = 8.0 * Math.pow(d3 + 2.0 * d2, 3.0) / (d2 * Math.pow(8.0 * d2 + 3.0 * d3, 2.0));
        double d7 = d4 * ChiSquareDistribution.quantile(d, d6) + d5;
        return 1.0 / d7;
    }

    private static double calculateZeroFinderApproximation(double d, double d2, double d3, int n, double d4, double d5) {
        final InverseGaussianDistribution inverseGaussianDistribution = new InverseGaussianDistribution(d2, d3);
        final double d6 = d;
        BisectionZeroFinder bisectionZeroFinder = new BisectionZeroFinder(new OneVariableFunction(){

            @Override
            public double value(double d) {
                return inverseGaussianDistribution.cdf(d) - d6;
            }
        }, d4, d5);
        bisectionZeroFinder.setMaximumIterations(n);
        bisectionZeroFinder.evaluate();
        return bisectionZeroFinder.getResult();
    }

    public static double mean(double d, double d2) {
        return d;
    }

    public static double variance(double d, double d2) {
        double d3 = InverseGaussianDistribution.calculateSD(d, d2);
        return d3 * d3;
    }
}

