/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.RandomFieldDistribution;

public class GaussianProcessBasisApproximation
extends RandomFieldDistribution {
    public static final String TYPE = "GaussianProcessBasisApproximation";
    protected final int knots;
    protected final int dim;
    protected final double degree;
    protected final double[] times;
    protected final double boundary;
    private final Parameter meanParameter;
    private final Parameter marginalVarianceParameter;
    private final Parameter lengthScaleParameter;
    private final Parameter coefficientParameter;
    private final Parameter precisionParameter;
    private final double precisionValue;
    private final double[][] basisMatrix;
    private final double[] mean;
    private final double[] coefficient;
    private double[] centeredTimes;
    private double[] storedCoefficient;
    private boolean coefficientKnown;
    private boolean storedCoefficientKnown;
    private boolean basisMatrixKnown;
    private boolean timesKnown;
    private boolean centeredTimesKnown;
    private boolean meanKnown;
    private boolean precisionKnown;

    public GaussianProcessBasisApproximation(String string, int n, int n2, double d, double[] dArray, double d2, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5) {
        super(string);
        this.dim = n;
        this.knots = n2;
        this.degree = d;
        this.times = dArray;
        this.boundary = d2;
        this.meanParameter = parameter;
        this.marginalVarianceParameter = parameter2;
        this.lengthScaleParameter = parameter3;
        this.precisionParameter = parameter5;
        this.coefficientParameter = parameter4;
        this.addVariable(this.meanParameter);
        this.addVariable(this.marginalVarianceParameter);
        this.addVariable(this.lengthScaleParameter);
        this.addVariable(this.precisionParameter);
        this.addVariable(this.coefficientParameter);
        this.coefficient = new double[n2];
        this.mean = new double[n];
        this.centeredTimes = new double[n];
        this.basisMatrix = new double[n][n2];
        this.basisMatrixKnown = false;
        this.coefficientKnown = false;
        this.timesKnown = false;
        this.centeredTimesKnown = false;
        this.meanKnown = false;
        this.precisionKnown = false;
        this.precisionValue = 0.0;
    }

    @Override
    public double[] getMean() {
        this.getBasisMatrix(this.times);
        if (!this.meanKnown) {
            for (int i = 0; i < this.dim; ++i) {
                double d = 0.0;
                for (int j = 0; j < this.knots; ++j) {
                    d += this.basisMatrix[i][j] * this.coefficientParameter.getParameterValue(j);
                }
                this.mean[i] = d + this.meanParameter.getParameterValue(0);
            }
            this.meanKnown = true;
        }
        return this.mean;
    }

    private double[] getCenteredTimes(double[] dArray) {
        if (!this.centeredTimesKnown) {
            double d = dArray[0];
            double d2 = dArray[0];
            double d3 = dArray[0];
            for (int i = 1; i < dArray.length; ++i) {
                d3 += dArray[i];
                if (dArray[i] > d) {
                    d = dArray[i];
                }
                if (!(dArray[i] < d2)) continue;
                d2 = dArray[i];
            }
            double d4 = d3 / (double)dArray.length;
            double d5 = 0.5 * (d - d2);
            for (int i = 0; i < dArray.length; ++i) {
                this.centeredTimes[i] = (dArray[i] - d4) / d5;
            }
            this.centeredTimesKnown = true;
        }
        return this.centeredTimes;
    }

    public static double getSpectralDensity(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        if (d4 == 1.5) {
            d5 = d2 * 12.0 * Math.sqrt(3.0) * Math.pow(d3, -3.0) / Math.pow(3.0 / (d3 * d3) + d * d * 4.0 * Math.PI * Math.PI, 2.0);
        }
        if (d4 == 2.5) {
            d5 = d2 * 133.0 * Math.sqrt(5.0) * Math.pow(d3, -5.0) / Math.pow(5.0 / (d3 * d3) + d * d * 4.0 * Math.PI * Math.PI, 3.0);
        }
        if (d4 == 0.5) {
            d5 = 2.0 / d3 / (1.0 / (d3 * d3) + 39.47841760435743 * d * d);
        } else if (d4 == -1.0) {
            d5 = d2 * Math.sqrt(Math.PI * 2) * d3 * Math.exp(-0.5 * d * d * d3 * d3);
        }
        return d5;
    }

    public static double getSpectralDensityEigenValue(int n, double d) {
        return (double)((n + 1) * (n + 1)) * Math.PI * Math.PI / (4.0 * d * d);
    }

    private double getSpectralDensityEigenFunction(int n, double d, double d2) {
        return Math.sin(Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, d2)) * (d + d2)) / Math.sqrt(d2);
    }

    private void getBasisMatrix(double[] dArray) {
        double d = this.marginalVarianceParameter.getParameterValue(0);
        double d2 = this.lengthScaleParameter.getParameterValue(0);
        double[] dArray2 = this.getCenteredTimes(dArray);
        if (!this.basisMatrixKnown) {
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < this.knots; ++j) {
                    this.basisMatrix[i][j] = Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensity(Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(j, this.boundary)), d, d2, this.degree)) * this.getSpectralDensityEigenFunction(j, dArray2[i], this.boundary);
                }
            }
            this.basisMatrixKnown = true;
        }
    }

    @Override
    public GradientProvider getGradientWrt(Parameter parameter) {
        if (parameter == this.coefficientParameter) {
            return new GradientProvider(){

                @Override
                public int getDimension() {
                    return GaussianProcessBasisApproximation.this.coefficientParameter.getDimension();
                }

                @Override
                public double[] getGradientLogDensity(Object object) {
                    GaussianProcessBasisApproximation.this.getBasisMatrix(GaussianProcessBasisApproximation.this.times);
                    double[] dArray = GaussianProcessBasisApproximation.gradLogPdf(GaussianProcessBasisApproximation.this.dim, GaussianProcessBasisApproximation.this.knots, (double[])object, GaussianProcessBasisApproximation.this.getMean(), GaussianProcessBasisApproximation.this.precisionParameter.getParameterValue(0), GaussianProcessBasisApproximation.this.basisMatrix);
                    return dArray;
                }
            };
        }
        throw new RuntimeException("Unknown parameter");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double logPdf(double[] dArray) {
        return MultivariateNormalDistribution.logPdf(dArray, this.getMean(), this.precisionParameter.getParameterValue(0), 1.0);
    }

    public double getSSE(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        double[] dArray4 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray4[i] = dArray[i] - dArray2[i];
        }
        double d = 0.0;
        for (n = 0; n < this.dim; ++n) {
            double d2 = 0.0;
            for (int i = 0; i < this.knots; ++i) {
                d2 += dArray3[n][i] * this.coefficientParameter.getParameterValue(i);
            }
            dArray4[n] = d2;
        }
        for (n = 0; n < this.dim; ++n) {
            d += dArray4[n] * dArray4[n];
        }
        return d;
    }

    public static double[] gradLogPdf(int n, int n2, double[] dArray, double[] dArray2, double d, double[][] dArray3) {
        int n3;
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            dArray5[n3] = dArray[n3] - dArray2[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            double d2 = 0.0;
            for (int i = 0; i < n; ++i) {
                d2 += dArray3[i][n3] * dArray5[i];
            }
            dArray4[n3] = d2 * d;
        }
        return dArray4;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] nextRandom() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new IllegalArgumentException("Unknown model");
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.lengthScaleParameter || variable == this.marginalVarianceParameter) {
            this.basisMatrixKnown = false;
            this.meanKnown = false;
        } else if (variable == this.coefficientParameter || variable == this.meanParameter) {
            this.meanKnown = false;
        } else if (variable == this.precisionParameter) {
            this.precisionKnown = false;
        } else {
            throw new IllegalArgumentException("Unknown variable");
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.meanKnown = false;
        this.basisMatrixKnown = false;
        this.precisionKnown = false;
    }

    @Override
    protected void acceptState() {
    }
}

