/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import cern.jet.random.Gamma;
import cern.jet.random.engine.RandomEngine;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.math.GammaFunction;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.GammaDistributionImpl;

public class GammaDistribution
implements Distribution,
GradientProvider,
HessianProvider {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return GammaDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double shape;
    protected double scale;
    protected int samples;
    private static final boolean TRY_COLT = false;
    private static RandomEngine randomEngine;
    private static Gamma coltGamma;

    public GammaDistribution(double d, double d2) {
        this.shape = d;
        this.scale = d2;
        this.samples = 0;
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double d) {
        this.shape = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    @Override
    public double pdf(double d) {
        return GammaDistribution.pdf(d, this.shape, this.scale);
    }

    @Override
    public double logPdf(double d) {
        return GammaDistribution.logPdf(d, this.shape, this.scale);
    }

    @Override
    public double cdf(double d) {
        return GammaDistribution.cdf(d, this.shape, this.scale);
    }

    @Override
    public double quantile(double d) {
        return GammaDistribution.quantile(d, this.shape, this.scale);
    }

    @Override
    public double mean() {
        return GammaDistribution.mean(this.shape, this.scale);
    }

    @Override
    public double variance() {
        return GammaDistribution.variance(this.shape, this.scale);
    }

    public double nextGamma() {
        return GammaDistribution.nextGamma(this.shape, this.scale);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d == 0.0) {
            if (d2 == 1.0) {
                return 1.0 / d3;
            }
            return 0.0;
        }
        if (d2 == 0.0) {
            return 1.0 / d;
        }
        if (d2 == -0.5) {
            return Math.sqrt(d);
        }
        double d4 = d / d3;
        if (d2 == 1.0) {
            return Math.exp(-d4) / d3;
        }
        double d5 = Math.exp((d2 - 1.0) * Math.log(d4) - d4 - GammaFunction.lnGamma(d2));
        return d5 / d3;
    }

    public static double logPdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 0.0) {
            if (d2 == 1.0) {
                return Math.log(1.0 / d3);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (d2 == 1.0) {
            return -d / d3 - Math.log(d3);
        }
        if (d2 == 0.0) {
            return -Math.log(d);
        }
        if (d2 == -0.5) {
            return 0.5 * Math.log(d);
        }
        return (d2 - 1.0) * (Math.log(d) - Math.log(d3)) - d / d3 - GammaFunction.lnGamma(d2) - Math.log(d3);
    }

    public static double gradLogPdf2(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d2 == 1.0) {
            return -1.0 / d3;
        }
        if (d == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d2 == 0.0) {
            return -1.0 / d;
        }
        if (d2 == -0.5) {
            return 0.5 / d;
        }
        return (d2 - 1.0) / d - 1.0 / d3;
    }

    public static double cdf(double d, double d2, double d3) {
        if (d < 0.0 || d2 <= 0.0) {
            return 0.0;
        }
        return GammaFunction.incompleteGammaP(d2, d / d3);
    }

    public static double quantile(double d, double d2, double d3) {
        return 0.5 * d3 * GammaDistribution.pointChi2(d, 2.0 * d2);
    }

    public static double mean(double d, double d2) {
        return d2 * d;
    }

    public static double variance(double d, double d2) {
        return d2 * d2 * d;
    }

    public static double nextGamma(double d, double d2) {
        return GammaDistribution.nextGamma(d, d2, false);
    }

    public static double nextGamma(double d, double d2, boolean bl) {
        double d3 = 0.0;
        if (d < 1.0E-5) {
            if (d < 0.0) {
                System.out.println("Negative shape parameter");
                throw new IllegalArgumentException("Negative shape parameter");
            }
            double d4 = 1.0E-20;
            double d5 = 50.0;
            double d6 = Math.log(d5) - Math.log(d4);
            while (Math.exp(-(d3 = Math.exp(Math.log(d4) + d6 * MathUtils.nextDouble()))) < MathUtils.nextDouble()) {
            }
            return d3;
        }
        if (bl && Math.floor(d) == d && d > 4.0) {
            int n = 0;
            while ((double)n < d) {
                d3 += -Math.log(MathUtils.nextDouble());
                ++n;
            }
            return d3 * d2;
        }
        if (d == 1.0) {
            return -Math.log(MathUtils.nextDouble()) * d2;
        }
        if (d == 2.0) {
            return -Math.log(MathUtils.nextDouble() * MathUtils.nextDouble()) * d2;
        }
        if (d == 3.0) {
            return -Math.log(MathUtils.nextDouble() * MathUtils.nextDouble() * MathUtils.nextDouble()) * d2;
        }
        if (d == 4.0) {
            return -Math.log(MathUtils.nextDouble() * MathUtils.nextDouble() * MathUtils.nextDouble() * MathUtils.nextDouble()) * d2;
        }
        do {
            try {
                d3 = GammaDistribution.quantile(MathUtils.nextDouble(), d, d2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                d3 = 0.0;
            }
        } while (d3 == 0.0);
        return d3;
    }

    public static double nextExpGamma(double d, double d2, double d3) {
        return GammaDistribution.nextExpGamma(d, d2, d3, false);
    }

    public static double nextExpGamma(double d, double d2, double d3, boolean bl) {
        double d4;
        int n = 0;
        if (bl) {
            double d5;
            do {
                d4 = GammaDistribution.nextGamma(d, d2);
                d5 = Math.exp(-1.0 / (d3 * d4));
            } while (MathUtils.nextDouble() > d5);
        } else {
            double d6;
            if (d < 0.0) {
                return 1.0 / GammaDistribution.nextExpGamma(-d, d3, d2);
            }
            if (d == 0.0) {
                double d7;
                double d8;
                double d9 = 1.0 / d3;
                double d10 = Math.sqrt(d2 / d3);
                if (d9 < d10) {
                    d9 = d10;
                }
                double d11 = 1.0 / d9 * Math.exp(-1.0 / (d3 * d9));
                do {
                    d7 = GammaDistribution.nextGamma(1.0, d2) + d10;
                    d8 = 1.0 / d7 * Math.exp(-1.0 / (d7 * d3)) / d11;
                } while (MathUtils.nextDouble() > d8 && ++n < 10000);
                if (n == 10000) {
                    System.out.println("Severe Warning: nextExpGamma (shape=0) failed to generate a sample - returning bogus value!");
                }
                if (MathUtils.nextDouble() > 0.5) {
                    d7 = d2 / (d3 * d7);
                }
                return d7;
            }
            if (d <= 0.0) {
                System.out.println("nextExpGamma: Illegal argument (shape parameter is must be positive)");
                throw new IllegalArgumentException("");
            }
            double d12 = (d * d2 + Math.sqrt(4.0 * d2 / d3 + d * d * d2 * d2)) / 2.0;
            double d13 = 1.0 / (1.0 / d2 - 1.0 / (d3 * d12 * d12));
            do {
                d4 = GammaDistribution.nextGamma(d, d13);
                d6 = Math.exp(-(d4 / d12 - 1.0) * (d4 / d12 - 1.0) / (d3 * d4));
            } while (MathUtils.nextDouble() > d6 && ++n < 10000);
            if (d6 > 1.0) {
                System.out.println("PROBLEM!!  This should be impossible!!  Contact the authors.");
            }
            if (d13 < 0.0) {
                System.out.println("PROBLEM!! This should be impossible too!!  Contact the authors.");
            }
            if (n == 10000) {
                System.out.println("Severe Warning: nextExpGamma failed to generate a sample - returning bogus value!");
            }
        }
        return d4;
    }

    public static double gradLogPdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d2 == -0.5) {
            return 0.5 / d;
        }
        if (d2 == 0.0) {
            return -1.0 / d;
        }
        if (d2 == 1.0) {
            return -1.0 / d3;
        }
        return (d2 - 1.0) / d - 1.0 / d3;
    }

    public static double hessianLogPdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d2 == -0.5) {
            return -0.5 / (d * d);
        }
        if (d2 == 0.0) {
            return 1.0 / (d * d);
        }
        if (d2 == 1.0) {
            return 0.0;
        }
        return (1.0 - d2) / (d * d);
    }

    private static double pointChi2(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16 = d;
        double d17 = 0.01;
        if (d16 < 2.0E-6 || d16 > 0.999998) {
            d17 = 1.0E-6;
        }
        double d18 = GammaFunction.lnGamma(d2 / 2.0);
        double d19 = d2 / 2.0;
        double d20 = d19 - 1.0;
        if (d2 < -1.24 * Math.log(d16)) {
            d15 = Math.pow(d16 * d19 * Math.exp(d18 + d19 * 0.6931471805), 1.0 / d19);
            if (d15 - 5.0E-7 < 0.0) {
                return d15;
            }
        } else if (d2 > 0.32) {
            double d21 = NormalDistribution.quantile(d16, 0.0, 1.0);
            d15 = d2 * Math.pow(d21 * Math.sqrt(d14 = 0.222222 / d2) + 1.0 - d14, 3.0);
            if (d15 > 2.2 * d2 + 6.0) {
                d15 = -2.0 * (Math.log(1.0 - d16) - d20 * Math.log(0.5 * d15) + d18);
            }
        } else {
            d15 = 0.4;
            d13 = Math.log(1.0 - d16);
            do {
                d12 = d15;
                d14 = 1.0 + d15 * (4.67 + d15);
                d11 = d15 * (6.73 + d15 * (6.66 + d15));
                d10 = -0.5 + (4.67 + 2.0 * d15) / d14 - (6.73 + d15 * (13.32 + 3.0 * d15)) / d11;
            } while (Math.abs(d12 / (d15 -= (1.0 - Math.exp(d13 + d18 + 0.5 * d15 + d20 * 0.6931471805) * d11 / d14) / d10) - 1.0) - d17 > 0.0);
        }
        do {
            double d22;
            d12 = d15;
            d14 = 0.5 * d15;
            d10 = GammaFunction.incompleteGammaP(d19, d14, d18);
            if (!(d22 < 0.0)) continue;
            throw new IllegalArgumentException("Arguments out of range: t < 0");
        } while (Math.abs(d12 / (d15 += (d10 = (d11 = d16 - d10) * Math.exp(d19 * 0.6931471805 + d18 + d14 - d20 * Math.log(d15))) * (1.0 + 0.5 * d10 * (d9 = (210.0 + (d13 = 0.5 * d10 - (d8 = d10 / d15) * d20) * (140.0 + d13 * (105.0 + d13 * (84.0 + d13 * (70.0 + 60.0 * d13))))) / 420.0) - d8 * d20 * (d9 - d8 * ((d7 = (420.0 + d13 * (735.0 + d13 * (966.0 + d13 * (1141.0 + 1278.0 * d13)))) / 2520.0) - d8 * ((d6 = (210.0 + d13 * (462.0 + d13 * (707.0 + 932.0 * d13))) / 2520.0) - d8 * ((d5 = (252.0 + d13 * (672.0 + 1182.0 * d13) + d20 * (294.0 + d13 * (889.0 + 1740.0 * d13))) / 5040.0) - d8 * ((d4 = (84.0 + 264.0 * d13 + d20 * (175.0 + 606.0 * d13)) / 2520.0) - d8 * (d3 = (120.0 + d20 * (346.0 + 127.0 * d20)) / 5040.0)))))))) - 1.0) > 5.0E-7);
        return d15;
    }

    public static void main(String[] stringArray) {
        GammaDistribution.testQuantile(1.0E-10, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantile(0.5, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantile(0.9999999999, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantileCM(1.0E-10, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantileCM(0.5, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantileCM(0.9999999999, 0.878328435043444, 0.0013696236839573005);
        for (double d = 0.0125; d < 1.0; d += 0.025) {
            System.out.print(d + ": ");
            try {
                System.out.println(new GammaDistributionImpl(0.878328435043444, 0.0013696236839573005).inverseCumulativeProbability(d));
                continue;
            }
            catch (MathException mathException) {
                System.out.println(mathException.getMessage());
            }
        }
        GammaDistribution gammaDistribution = new GammaDistribution(0.01, 100.0);
        double[] dArray = new double[100000];
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = gammaDistribution.nextGamma();
            d += dArray[i];
        }
        double d2 = d / (double)dArray.length;
        System.out.println("Mean = " + d2);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += Math.pow(dArray[i] - d2, 2.0);
        }
        System.out.println("Variance = " + (d3 /= (double)dArray.length));
    }

    private static void testQuantile(double d, double d2, double d3) {
        long l = System.currentTimeMillis();
        double d4 = 0.0;
        for (int i = 0; i < 1000; ++i) {
            d4 = GammaDistribution.quantile(d, d2, d3);
        }
        d4 = GammaDistribution.quantile(d, d2, d3);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Quantile, " + d + ", for shape=" + d2 + ", scale=" + d3 + " : " + d4 + ", time=" + l2 + "ms");
    }

    private static void testQuantileCM(double d, double d2, double d3) {
        long l = System.currentTimeMillis();
        double d4 = 0.0;
        try {
            for (int i = 0; i < 1000; ++i) {
                d4 = new GammaDistributionImpl(d2, d3).inverseCumulativeProbability(d);
            }
            d4 = new GammaDistributionImpl(d2, d3).inverseCumulativeProbability(d);
        }
        catch (MathException mathException) {
            mathException.printStackTrace();
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.println("commons.maths inverseCDF, " + d + ", for shape=" + d2 + ", scale=" + d3 + " : " + d4 + ", time=" + l2 + "ms");
    }

    private static double KolmogorovSmirnov(List<Double> list, List<Double> list2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            while (n < list2.size() && list2.get(n) < list.get(i)) {
                ++n;
            }
            n2 = Math.max(n2, n - i);
        }
        return (double)n2 / Math.sqrt(2.0 * (double)list.size());
    }

    private static void testExpGamma2(double d, double d2, double d3, int n, double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>(0);
        for (int i = 0; i < n; ++i) {
            double d8 = GammaDistribution.nextExpGamma(d, d2, d3, false);
            d5 += 1.0;
            d6 += d8;
            d7 += d8 * d8;
            arrayList.add(d8);
        }
        Collections.sort(arrayList);
        double d9 = d6 / d5;
        double d10 = (d7 - d6 * d6 / d5) / d5;
        double d11 = (d4 - d9) / Math.sqrt(d10 / (double)n);
        System.out.println("Equal-mean test: (shape=" + d + " scale=" + d2 + " bias=" + d3 + " mean=" + d9 + " expected=" + d4 + " var=" + d10 + " median=" + arrayList.get(n / 2) + "): z=" + d11);
    }

    private static void testExpGamma(double d, double d2, double d3, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(0);
        ArrayList<Double> arrayList2 = new ArrayList<Double>(0);
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            arrayList.add(GammaDistribution.nextExpGamma(d, d2, d3, true));
        }
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(GammaDistribution.nextExpGamma(d, d2, d3, false));
        }
        long l3 = System.currentTimeMillis() - l2;
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        System.out.println("KS test for shape=" + d + ", bias=" + d3 + " : " + GammaDistribution.KolmogorovSmirnov(arrayList, arrayList2) + " and " + GammaDistribution.KolmogorovSmirnov(arrayList2, arrayList) + " slow=" + (l2 -= l) + "ms, fast=" + l3 + "ms");
    }

    private static void test(double d, double d2, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(0);
        ArrayList<Double> arrayList2 = new ArrayList<Double>(0);
        for (int i = 0; i < n; ++i) {
            arrayList.add(GammaDistribution.nextGamma(d, d2, true));
            arrayList2.add(GammaDistribution.nextGamma(d, d2, false));
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        System.out.println("KS test for shape=" + d + " : " + GammaDistribution.KolmogorovSmirnov(arrayList, arrayList2) + " and " + GammaDistribution.KolmogorovSmirnov(arrayList2, arrayList));
    }

    private static void testAddition(double d, double d2, int n, int n2) {
        ArrayList<Double> arrayList = new ArrayList<Double>(0);
        ArrayList<Double> arrayList2 = new ArrayList<Double>(0);
        ArrayList<Double> arrayList3 = new ArrayList<Double>(0);
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d3 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d3 += GammaDistribution.nextGamma(d, d2, true);
            }
            arrayList.add(d3);
            d3 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d3 += GammaDistribution.nextGamma(d, d2, false);
            }
            arrayList2.add(d3);
            arrayList3.add(GammaDistribution.nextGamma(d * (double)n, d2, true));
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        Collections.sort(arrayList3);
        System.out.println("KS test for shape=" + d + " : slow=" + GammaDistribution.KolmogorovSmirnov(arrayList, arrayList3) + " & " + GammaDistribution.KolmogorovSmirnov(arrayList3, arrayList) + "; fast=" + GammaDistribution.KolmogorovSmirnov(arrayList2, arrayList3) + " & " + GammaDistribution.KolmogorovSmirnov(arrayList3, arrayList2));
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = GammaDistribution.gradLogPdf(dArray[i], this.shape, this.scale);
        }
        return dArray2;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = GammaDistribution.hessianLogPdf(dArray[i], this.shape, this.scale);
        }
        return dArray2;
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        return HessianProvider.expandDiagonals(this.getDiagonalHessianLogDensity(object));
    }
}

