/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.AbstractTraceList;
import dr.inference.trace.Trace;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayTraceList
extends AbstractTraceList {
    String name;
    Map<String, Integer> traceIndex = new HashMap<String, Integer>();
    long burnin = 0L;
    List<Trace> traces;
    long stepSize;

    public ArrayTraceList(String string, List<Trace> list, int n) {
        this.name = string;
        this.traces = list;
        this.burnin = n;
        for (int i = 0; i < list.size(); ++i) {
            this.traceIndex.put(list.get(i).getName(), i);
        }
        Trace trace = list.get(0);
        this.stepSize = (int)Math.round(Double.valueOf(trace.getValue(1)) - Double.valueOf(trace.getValue(0)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int getTraceCount() {
        return this.traces.size();
    }

    @Override
    public int getTraceIndex(String string) {
        Integer n = this.traceIndex.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public String getTraceName(int n) {
        return this.traces.get(n).getName();
    }

    @Override
    public long getBurnIn() {
        return this.burnin;
    }

    @Override
    public int getStateCount() {
        return this.traces.get(0).getValueCount();
    }

    @Override
    public int getBurninStateCount() {
        return (int)(this.getBurnIn() / this.stepSize);
    }

    @Override
    public long getStepSize() {
        return this.stepSize;
    }

    @Override
    public long getMaxState() {
        return (long)this.getStateCount() * this.getStepSize();
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public List<Double> getValues(int n, int n2, int n3) {
        throw new UnsupportedOperationException("not available");
    }

    @Override
    public List<Double> getValues(int n) {
        throw new UnsupportedOperationException("not available");
    }

    @Override
    public List<Double> getBurninValues(int n) {
        throw new UnsupportedOperationException("not available");
    }

    @Override
    public Trace getTrace(int n) {
        return this.traces.get(n);
    }
}

