/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.factorAnalysis.LoadingsGibbsTruncatedOperator;
import dr.math.MathUtils;

public class LoadingsSparsityOperator
extends SimpleMCMCOperator {
    LoadingsGibbsTruncatedOperator loadingsGibbs;
    MatrixParameterInterface sparse;

    public LoadingsSparsityOperator(double d, LoadingsGibbsTruncatedOperator loadingsGibbsTruncatedOperator, MatrixParameterInterface matrixParameterInterface) {
        this.setWeight(d);
        this.loadingsGibbs = loadingsGibbsTruncatedOperator;
        this.sparse = matrixParameterInterface;
    }

    @Override
    public String getOperatorName() {
        return "LoadingsSparsityOperator";
    }

    @Override
    public double doOperation() {
        int n = MathUtils.nextInt(this.sparse.getRowDimension());
        int n2 = MathUtils.nextInt(this.sparse.getColumnDimension());
        double d = 0.0;
        d += this.loadingsGibbs.drawI(n, n2, false);
        if (this.sparse.getParameterValue(n, n2) == 0.0) {
            this.sparse.setParameterValue(n, n2, 1.0);
        } else {
            this.sparse.setParameterValue(n, n2, 0.0);
        }
        if (Double.isNaN(d -= this.loadingsGibbs.drawI(n, n2, true))) {
            System.out.println("is NaN");
        }
        if (Double.isInfinite(d)) {
            return Double.NEGATIVE_INFINITY;
        }
        return d;
    }
}

